package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.AcquireTokenRequest;
import com.xforceplus.micro.tax.device.contract.model.AcquireTokenResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "auth", description = "the auth API")
public interface AuthApi {

    @ApiOperation(value = "获取token", notes = "", response = AcquireTokenResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "客户端获取token响应", response = AcquireTokenResponse.class) })
    @RequestMapping(value = "/auth/acquireToken",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AcquireTokenResponse authAcquireTokenPost(@ApiParam(value = "客户端获取token"  )  @Valid @RequestBody AcquireTokenRequest acquireTokenRequest) {
        Object[] params = new Object[] { acquireTokenRequest };
        //return FixtureService.getInstance().get(AcquireTokenResponse.class, AuthApi.class, "authAcquireTokenPost", params);
        return null;
    }
}
