package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.CancelDeviceStockRequest;
import com.xforceplus.micro.tax.device.contract.model.GetSubscribeDeviceStockResponse;
import com.xforceplus.micro.tax.device.contract.model.SubscribeDeviceStockRequest;
import com.xforceplus.micro.tax.device.contract.model.SubscribeDeviceStockResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "device-stock", description = "the device-stock API")
public interface DeviceStockApi {

    @ApiOperation(value = "取消税盘库存订阅", notes = "", response = SubscribeDeviceStockResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "税盘库存订阅响应", response = SubscribeDeviceStockResponse.class) })
    @RequestMapping(value = "/device-stock/device-stock-subscribe",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.DELETE)
    default SubscribeDeviceStockResponse cancelDeviceStock(@ApiParam(value = "取消税盘库存订阅请求"  )  @Valid @RequestBody CancelDeviceStockRequest cancelDeviceStockRequest) {
        Object[] params = new Object[] { cancelDeviceStockRequest };
        //return FixtureService.getInstance().get(SubscribeDeviceStockResponse.class, DeviceStockApi.class, "cancelDeviceStock", params);
        return null;
    }

    @ApiOperation(value = "获取税盘库存订阅信息", notes = "", response = GetSubscribeDeviceStockResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "获取税盘库存订阅信息响应", response = GetSubscribeDeviceStockResponse.class) })
    @RequestMapping(value = "/device-stock/device-stock-subscribe",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.GET)
    default GetSubscribeDeviceStockResponse getSubscribeDeviceStock(@NotNull @ApiParam(value = "税盘唯一码", required = true) @Valid @RequestParam(value = "deviceUn", required = true) String deviceUn,@NotNull @ApiParam(value = "来源系统", required = true) @Valid @RequestParam(value = "fromSystem", required = true) String fromSystem) {
        Object[] params = new Object[] { deviceUn, fromSystem };
        //return FixtureService.getInstance().get(GetSubscribeDeviceStockResponse.class, DeviceStockApi.class, "getSubscribeDeviceStock", params);
        return null;
    }

    @ApiOperation(value = "税盘库存订阅", notes = "", response = SubscribeDeviceStockResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "税盘库存订阅响应", response = SubscribeDeviceStockResponse.class) })
    @RequestMapping(value = "/device-stock/device-stock-subscribe",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default SubscribeDeviceStockResponse subscribeDeviceStock(@ApiParam(value = "税盘库存订阅"  )  @Valid @RequestBody SubscribeDeviceStockRequest subscribeDeviceStockRequest) {
        Object[] params = new Object[] { subscribeDeviceStockRequest };
        //return FixtureService.getInstance().get(SubscribeDeviceStockResponse.class, DeviceStockApi.class, "subscribeDeviceStock", params);
        return null;
    }
}
