package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.ClientLoginInfoRequest;
import com.xforceplus.micro.tax.device.contract.model.ClientLoginInfoResponse;
import com.xforceplus.micro.tax.device.contract.model.ClientStockRequest;
import com.xforceplus.micro.tax.device.contract.model.ClientStockResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "client", description = "the client API")
public interface ClientApi {

    @ApiOperation(value = "客户端库存信息", notes = "", response = ClientStockResponse.class, tags={ "Client", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "客户端库存响应", response = ClientStockResponse.class) })
    @RequestMapping(value = "/client/stock",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ClientStockResponse clientStock(@ApiParam(value = "客户端库存请求"  )  @Valid @RequestBody ClientStockRequest clientStockRequest) {
        Object[] params = new Object[] { clientStockRequest };
        //return FixtureService.getInstance().get(ClientStockResponse.class, ClientApi.class, "clientStock", params);
        return null;
    }

    @ApiOperation(value = "客户端登录信息收集", notes = "", response = ClientLoginInfoResponse.class, tags={ "Client", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "客户端登录信息收集响应", response = ClientLoginInfoResponse.class) })
    @RequestMapping(value = "/client/loginInfo",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ClientLoginInfoResponse saveClientLoginInfo(@ApiParam(value = "客户端登录信息收集请求"  )  @Valid @RequestBody ClientLoginInfoRequest clientLoginInfoRequest) {
        Object[] params = new Object[] { clientLoginInfoRequest };
        //return FixtureService.getInstance().get(ClientLoginInfoResponse.class, ClientApi.class, "saveClientLoginInfo", params);
        return null;
    }
}
