package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.ClientUpdateRequest;
import com.xforceplus.micro.tax.device.contract.model.ClientUpdateResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "clientUpdate", description = "the clientUpdate API")
public interface ClientUpdateApi {

    @ApiOperation(value = "客户端升级", notes = "", response = ClientUpdateResponse.class, tags={ "Client", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "客户端升级响应", response = ClientUpdateResponse.class) })
    @RequestMapping(value = "/clientUpdate/downloadLinks/generate",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ClientUpdateResponse clientUpdateDownloadLinksGeneratePost(@ApiParam(value = "客户端升级请求"  )  @Valid @RequestBody ClientUpdateRequest clientUpdateRequest) {
        Object[] params = new Object[] { clientUpdateRequest };
        //return FixtureService.getInstance().get(ClientUpdateResponse.class, ClientUpdateApi.class, "clientUpdateDownloadLinksGeneratePost", params);
        return null;
    }
}
