package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.QueryConfigInfoRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryConfigInfoResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "config", description = "the config API")
public interface ConfigApi {

    @ApiOperation(value = "查询配置信息", notes = "", response = QueryConfigInfoResponse.class, tags={ "Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询配置信息", response = QueryConfigInfoResponse.class) })
    @RequestMapping(value = "/config/queryConfig",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryConfigInfoResponse configQueryConfigPost(@ApiParam(value = "查询配置信息"  )  @Valid @RequestBody QueryConfigInfoRequest queryConfigInfoRequest) {
        Object[] params = new Object[] { queryConfigInfoRequest };
        //return FixtureService.getInstance().get(QueryConfigInfoResponse.class, ConfigApi.class, "configQueryConfigPost", params);
        return null;
    }
}
