/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.mybaitis.generator.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.StringUtility;

public class MapperPlugin
extends PluginAdapter {
    private static final String DEFAULT_DAO_SUPER_CLASS = "com.dfz.base.BaseMapper";
    private static final String DEFAULT_EXPAND_DAO_SUPER_CLASS = "com.dfz.base.BaseExpandMapper";
    private String daoTargetDir;
    private String daoTargetPackage;
    private String daoSuperClass;
    private String expandDaoTargetPackage;
    private String expandDaoSuperClass;
    private ShellCallback shellCallback = new DefaultShellCallback(false);

    public boolean validate(List<String> warnings) {
        this.daoTargetDir = this.properties.getProperty("targetProject");
        boolean valid = StringUtility.stringHasValue((String)this.daoTargetDir);
        this.daoTargetPackage = this.properties.getProperty("targetPackage");
        boolean valid2 = StringUtility.stringHasValue((String)this.daoTargetPackage);
        this.daoSuperClass = this.properties.getProperty("daoSuperClass");
        if (!StringUtility.stringHasValue((String)this.daoSuperClass)) {
            this.daoSuperClass = DEFAULT_DAO_SUPER_CLASS;
        }
        this.expandDaoTargetPackage = this.properties.getProperty("expandTargetPackage");
        this.expandDaoSuperClass = this.properties.getProperty("expandDaoSuperClass");
        if (!StringUtility.stringHasValue((String)this.expandDaoSuperClass)) {
            this.expandDaoSuperClass = DEFAULT_EXPAND_DAO_SUPER_CLASS;
        }
        return valid && valid2;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement select = new XmlElement("select");
        select.addAttribute(new Attribute("id", "selectAll"));
        select.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        select.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        select.addElement((Element)new TextElement(" select <include refid=\"Base_Column_List\" /> from " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        XmlElement parentElement = document.getRootElement();
        parentElement.addElement((Element)select);
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        JavaFormatter javaFormatter = this.context.getJavaFormatter();
        ArrayList<GeneratedJavaFile> mapperJavaFiles = new ArrayList<GeneratedJavaFile>();
        for (GeneratedJavaFile javaFile : introspectedTable.getGeneratedJavaFiles()) {
            FullyQualifiedJavaType daoSuperType;
            Interface mapperInterface;
            introspectedTable.getDAOImplementationType();
            CompilationUnit unit = javaFile.getCompilationUnit();
            FullyQualifiedJavaType baseModelJavaType = unit.getType();
            String shortName = baseModelJavaType.getShortName();
            GeneratedJavaFile mapperJavafile = null;
            if (shortName.endsWith("Mapper")) {
                if (!StringUtility.stringHasValue((String)this.expandDaoTargetPackage)) continue;
                mapperInterface = new Interface(this.expandDaoTargetPackage + "." + shortName.replace("Mapper", "ExpandMapper"));
                mapperInterface.setVisibility(JavaVisibility.PUBLIC);
                mapperInterface.addJavaDocLine("/**");
                mapperInterface.addJavaDocLine(" * " + shortName + "\u6269\u5c55");
                mapperInterface.addJavaDocLine(" */");
                daoSuperType = new FullyQualifiedJavaType(this.expandDaoSuperClass);
                mapperInterface.addImportedType(daoSuperType);
                mapperInterface.addSuperInterface(daoSuperType);
                mapperJavafile = new GeneratedJavaFile((CompilationUnit)mapperInterface, this.daoTargetDir, javaFormatter);
                try {
                    File mapperDir = this.shellCallback.getDirectory(this.daoTargetDir, this.daoTargetPackage);
                    File mapperFile = new File(mapperDir, mapperJavafile.getFileName());
                    if (mapperFile.exists()) continue;
                    mapperJavaFiles.add(mapperJavafile);
                }
                catch (ShellException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (shortName.endsWith("Example") || shortName.endsWith("Entity")) continue;
            mapperInterface = new Interface(this.daoTargetPackage + "." + shortName + "");
            mapperInterface.setVisibility(JavaVisibility.PUBLIC);
            mapperInterface.addJavaDocLine("/**");
            mapperInterface.addJavaDocLine(" * \u7531MyBatis Generator\u5de5\u5177\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u4e0d\u8981\u624b\u52a8\u4fee\u6539");
            mapperInterface.addJavaDocLine(" */");
            daoSuperType = new FullyQualifiedJavaType(this.daoSuperClass);
            String domainObjectFullName = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage() + "." + introspectedTable.getFullyQualifiedTable().getDomainObjectName();
            FullyQualifiedJavaType domainObjectType = new FullyQualifiedJavaType(domainObjectFullName);
            daoSuperType.addTypeArgument(domainObjectType);
            mapperInterface.addImportedType(domainObjectType);
            mapperInterface.addImportedType(daoSuperType);
            mapperInterface.addSuperInterface(daoSuperType);
            mapperJavafile = new GeneratedJavaFile((CompilationUnit)mapperInterface, this.daoTargetDir, javaFormatter);
            mapperJavaFiles.add(mapperJavafile);
        }
        return mapperJavaFiles;
    }
}

