/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.mybaitis.generator.utils;

import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.config.Context;

public class MethodGeneratorTool {
    private static final String BATCH_INSERT = "batchInsert";
    private static final String PARAMETER_NAME = "recordList";
    private static final String DELETE_PARAMETER_NAME = "ids";
    private static final String BATCH_UPDATE = "batchUpdate";
    private static final String BATCH_DELETE = "batchDelete";
    public static final Integer INSERT = 0;
    public static final Integer UPDATE = 1;

    public static Method methodGenerator(String methodName, JavaVisibility visibility, FullyQualifiedJavaType returnJavaType, Parameter ... parameters) {
        Method method = new Method();
        method.setName(methodName);
        method.setVisibility(visibility);
        method.setReturnType(returnJavaType);
        for (Parameter parameter : parameters) {
            method.addParameter(parameter);
        }
        return method;
    }

    public static Set<FullyQualifiedJavaType> importedBaseTypesGenerator(IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType parameterType = introspectedTable.getRules().calculateAllFieldsClass();
        FullyQualifiedJavaType paramType = new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param");
        FullyQualifiedJavaType intInstance = FullyQualifiedJavaType.getIntInstance();
        FullyQualifiedJavaType listParameterType = FullyQualifiedJavaType.getNewListInstance();
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        importedTypes.add(parameterType);
        importedTypes.add(intInstance);
        importedTypes.add(paramType);
        importedTypes.add(listParameterType);
        return importedTypes;
    }

    public static void defaultBatchInsertOrUpdateMethodGen(Integer type, Interface interfaze, IntrospectedTable introspectedTable, Context context) {
        Set<FullyQualifiedJavaType> importedTypes = MethodGeneratorTool.importedBaseTypesGenerator(introspectedTable);
        FullyQualifiedJavaType listParameterType = FullyQualifiedJavaType.getNewListInstance();
        listParameterType.addTypeArgument(introspectedTable.getRules().calculateAllFieldsClass());
        String methodName = BATCH_INSERT;
        if (type.equals(UPDATE)) {
            methodName = BATCH_UPDATE;
        }
        Method insertMethod = MethodGeneratorTool.methodGenerator(methodName, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(listParameterType, PARAMETER_NAME, "@Param(\"recordList\")"));
        CommentGenerator commentGenerator = context.getCommentGenerator();
        commentGenerator.addGeneralMethodComment(insertMethod, introspectedTable);
        interfaze.addImportedTypes(importedTypes);
        interfaze.addMethod(insertMethod);
    }

    public static void defaultBatchDeleteMethodGen(Interface interfaze, IntrospectedTable introspectedTable, Context context) {
        Set<FullyQualifiedJavaType> importedTypes = MethodGeneratorTool.importedBaseTypesGenerator(introspectedTable);
        FullyQualifiedJavaType paramType = ((IntrospectedColumn)introspectedTable.getPrimaryKeyColumns().get(0)).getFullyQualifiedJavaType();
        Method batchDeleteMethod = MethodGeneratorTool.methodGenerator(BATCH_DELETE, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(new FullyQualifiedJavaType(paramType.getFullyQualifiedName() + "[]"), DELETE_PARAMETER_NAME, "@Param(\"ids\")"));
        context.getCommentGenerator().addGeneralMethodComment(batchDeleteMethod, introspectedTable);
        interfaze.addImportedTypes(importedTypes);
        interfaze.addMethod(batchDeleteMethod);
    }
}

