/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.esutils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.phoenix.esutils.service.BaseElasticService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.HasParentQueryBuilder;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class EsPageQueryUtils {
    private static final Logger log = LoggerFactory.getLogger(EsPageQueryUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EsPageQueryUtils.class);
    private static final int rangeQuerySize = 2;
    @Autowired
    BaseElasticService baseElasticService;
    @Value(value="${es7.timeout:5}")
    public static int timeout = 600;
    @Value(value="${es7.camelToUnderscore:false}")
    public static boolean camelToUnderscore;

    public static SearchResponse aggregationQueryResponseEs7(String indexName, BaseElasticService staticBaseElasticService, SearchSourceBuilder searchSourceBuilder, AbstractAggregationBuilder abstractAggregationBuilder) {
        searchSourceBuilder.aggregation((AggregationBuilder)abstractAggregationBuilder);
        log.info("before running: " + searchSourceBuilder.toString());
        SearchResponse search = staticBaseElasticService.search(indexName, searchSourceBuilder);
        return search;
    }

    public static SearchSourceBuilder totalCountEs7(SearchModel searchModel) {
        LOGGER.info("totalCountEs7 searchModel:{}", (Object)searchModel);
        SearchSourceBuilder searchQuery = EsPageQueryUtils.getCountQueryEs7(searchModel);
        return searchQuery;
    }

    public static SearchSourceBuilder getCountQueryEs7(SearchModel searchModel) {
        QueryBuilder queryBuilder = EsPageQueryUtils.getQueryBuilder(searchModel);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        log.info(searchSourceBuilder.toString());
        return searchSourceBuilder;
    }

    public static <T> ResPageList<T> getPageListEs7(BaseElasticService staticBaseElasticService, Class<T> clazz, SearchModel searchModel, List<String> fields) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.getPageQueryEs7(searchModel, fields);
        SearchResponse searchResponse = staticBaseElasticService.search(searchModel.getIndex(), searchSourceBuilder);
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Object> res = new ArrayList<Object>(hits.length);
        for (SearchHit hit : hits) {
            res.add(JSON.parseObject((String)hit.getSourceAsString(), clazz));
        }
        ResPageList result = new ResPageList(searchResponse.getHits().getTotalHits().value, res);
        return result;
    }

    public static SearchSourceBuilder hasParentCountQueryEs7(SearchModel searchModel, List<String> fields) {
        QueryBuilder queryBuilder = EsPageQueryUtils.hasParentQueryBuilderNoInner(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilderNoPage(queryBuilder, timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static SearchSourceBuilder hasChildPageQueryEs7(SearchModel searchModel, List<String> fields, boolean innerHitOpen) {
        QueryBuilder queryBuilder = innerHitOpen ? EsPageQueryUtils.hasChildQueryBuilder(searchModel) : EsPageQueryUtils.hasChildQueryBuilderNoInner(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilder(queryBuilder, searchModel.getPageNo() - 1, searchModel.getPageSize(), timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static SearchSourceBuilder hasParentPageQueryEs7(SearchModel searchModel, List<String> fields, boolean innerHitOpen) {
        QueryBuilder queryBuilder = innerHitOpen ? EsPageQueryUtils.hasParentQueryBuilder(searchModel) : EsPageQueryUtils.hasChildQueryBuilderNoInner(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilder(queryBuilder, searchModel.getPageNo() - 1, searchModel.getPageSize(), timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static SearchSourceBuilder hasChildCountQueryEs7(SearchModel searchModel, List<String> fields) {
        QueryBuilder queryBuilder = EsPageQueryUtils.hasChildQueryBuilderNoInner(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilderNoPage(queryBuilder, timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static SearchSourceBuilder getPageQueryEs7(SearchModel searchModel, List<String> fields) {
        QueryBuilder queryBuilder = EsPageQueryUtils.getQueryBuilder(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilder(queryBuilder, searchModel.getPageNo() - 1, searchModel.getPageSize(), timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static SearchSourceBuilder initSearchSourceBuilder(QueryBuilder queryBuilder, int from, int size, int timeout, SearchSort searchSort, List<String> fields) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.query(queryBuilder);
        sourceBuilder.from(from * size);
        sourceBuilder.size(size);
        sourceBuilder.timeout(new TimeValue((long)timeout, TimeUnit.SECONDS));
        if (!CollectionUtils.isEmpty(fields)) {
            String[] fetchFields = EsPageQueryUtils.getFetchFields(fields, camelToUnderscore);
            FetchSourceContext sourceContext = new FetchSourceContext(true, fetchFields, null);
            sourceBuilder.fetchSource(sourceContext);
        }
        EsPageQueryUtils.getSortBuilderFromSearchSort(sourceBuilder, searchSort);
        log.info(sourceBuilder.toString());
        return sourceBuilder;
    }

    public static SearchSourceBuilder initSearchSourceBuilderNoPage(QueryBuilder queryBuilder, int timeout, SearchSort searchSort, List<String> fields) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(queryBuilder);
        if (!CollectionUtils.isEmpty(fields)) {
            String[] fetchFields = EsPageQueryUtils.getFetchFields(fields, camelToUnderscore);
            FetchSourceContext sourceContext = new FetchSourceContext(true, fetchFields, null);
            sourceBuilder.fetchSource(sourceContext);
        }
        EsPageQueryUtils.getSortBuilderFromSearchSort(sourceBuilder, searchSort);
        log.info(sourceBuilder.toString());
        return sourceBuilder;
    }

    private static String[] getFetchFields(List<String> fields, boolean camelToUnderscore) {
        String[] underScoredFields = new String[fields.size()];
        if (camelToUnderscore) {
            for (int i = 0; i < fields.size(); ++i) {
                underScoredFields[i] = EsPageQueryUtils.camelToUnderscore(fields.get(i), camelToUnderscore);
            }
            return underScoredFields;
        }
        return fields.toArray(underScoredFields);
    }

    private static void getSortBuilderFromSearchSort(SearchSourceBuilder sourceBuilder, SearchSort searchSort) {
        if (null != searchSort) {
            List<SearchSort> multipleSort = searchSort.getSearchSort();
            if (!CollectionUtils.isEmpty(multipleSort)) {
                multipleSort.forEach(a -> {
                    if ("0".equals(a.getSort())) {
                        sourceBuilder.sort(EsPageQueryUtils.camelToUnderscore(a.getFieldName(), camelToUnderscore), SortOrder.fromString((String)"ASC"));
                    }
                    if ("1".equals(a.getSort())) {
                        sourceBuilder.sort(EsPageQueryUtils.camelToUnderscore(a.getFieldName(), camelToUnderscore), SortOrder.fromString((String)"DESC"));
                    }
                });
            } else {
                if ("0".equals(searchSort.getSort())) {
                    sourceBuilder.sort(EsPageQueryUtils.camelToUnderscore(searchSort.getFieldName(), camelToUnderscore), SortOrder.fromString((String)"ASC"));
                }
                if ("1".equals(searchSort.getSort())) {
                    sourceBuilder.sort(EsPageQueryUtils.camelToUnderscore(searchSort.getFieldName(), camelToUnderscore), SortOrder.fromString((String)"DESC"));
                }
            }
        }
    }

    public static QueryBuilder getQueryBuilder(SearchModel searchModel) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (Objects.nonNull(searchModel)) {
            boolQueryBuilder.must((QueryBuilder)EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getGroups()));
            if (!CollectionUtils.isEmpty(searchModel.getAuthorizationGroups())) {
                boolQueryBuilder.must((QueryBuilder)EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getAuthorizationGroups()));
            }
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder hasParentQueryBuilder(SearchModel searchModel) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (Objects.nonNull(searchModel)) {
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            BoolQueryBuilder parentBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getGroups());
            if (!CollectionUtils.isEmpty(searchModel.getAuthorizationGroups())) {
                BoolQueryBuilder authorizationQueryBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getAuthorizationGroups());
                boolQueryBuilder2.must((QueryBuilder)authorizationQueryBuilder);
            }
            boolQueryBuilder2.must((QueryBuilder)parentBuilder);
            HasParentQueryBuilder hasParentQueryBuilder = JoinQueryBuilders.hasParentQuery((String)searchModel.getType(), (QueryBuilder)boolQueryBuilder2, (boolean)false).innerHit(new InnerHitBuilder());
            if (Objects.nonNull(searchModel.getChildGroups())) {
                BoolQueryBuilder childBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getChildGroups());
                boolQueryBuilder.must((QueryBuilder)childBuilder);
            }
            boolQueryBuilder.must((QueryBuilder)hasParentQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder hasParentQueryBuilderNoInner(SearchModel searchModel) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (Objects.nonNull(searchModel)) {
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            BoolQueryBuilder parentBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getGroups());
            if (!CollectionUtils.isEmpty(searchModel.getAuthorizationGroups())) {
                BoolQueryBuilder authorizationQueryBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getAuthorizationGroups());
                boolQueryBuilder2.must((QueryBuilder)authorizationQueryBuilder);
            }
            boolQueryBuilder2.must((QueryBuilder)parentBuilder);
            HasParentQueryBuilder hasParentQueryBuilder = JoinQueryBuilders.hasParentQuery((String)searchModel.getType(), (QueryBuilder)boolQueryBuilder2, (boolean)false);
            if (Objects.nonNull(searchModel.getChildGroups())) {
                BoolQueryBuilder childBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getChildGroups());
                boolQueryBuilder.must((QueryBuilder)childBuilder);
            }
            boolQueryBuilder.must((QueryBuilder)hasParentQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static SearchSourceBuilder hasParentQueryBuilderES7(SearchModel searchModel, List<String> fields, boolean innerHitOpen) {
        QueryBuilder queryBuilder = innerHitOpen ? EsPageQueryUtils.hasParentQueryBuilder(searchModel) : EsPageQueryUtils.hasParentQueryBuilderNoInner(searchModel);
        SearchSourceBuilder searchSourceBuilder = EsPageQueryUtils.initSearchSourceBuilder(queryBuilder, searchModel.getPageNo() - 1, searchModel.getPageSize(), timeout, searchModel.getSort(), fields);
        return searchSourceBuilder;
    }

    public static QueryBuilder hasChildQueryBuilder(SearchModel searchModel) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (Objects.nonNull(searchModel)) {
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            BoolQueryBuilder childBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getChildGroups());
            HasChildQueryBuilder hasChildQueryBuilder = JoinQueryBuilders.hasChildQuery((String)searchModel.getChildType(), (QueryBuilder)childBuilder, (ScoreMode)ScoreMode.None).innerHit(new InnerHitBuilder());
            BoolQueryBuilder parentBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getGroups());
            boolQueryBuilder2.must((QueryBuilder)parentBuilder);
            if (!CollectionUtils.isEmpty(searchModel.getAuthorizationGroups())) {
                boolQueryBuilder2.must((QueryBuilder)EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getAuthorizationGroups()));
            }
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2);
            boolQueryBuilder.must((QueryBuilder)hasChildQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder hasChildQueryBuilderNoInner(SearchModel searchModel) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (Objects.nonNull(searchModel)) {
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
            BoolQueryBuilder childBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getChildGroups());
            HasChildQueryBuilder hasChildQueryBuilder = JoinQueryBuilders.hasChildQuery((String)searchModel.getChildType(), (QueryBuilder)childBuilder, (ScoreMode)ScoreMode.None);
            BoolQueryBuilder parentBuilder = EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getGroups());
            boolQueryBuilder2.must((QueryBuilder)parentBuilder);
            if (!CollectionUtils.isEmpty(searchModel.getAuthorizationGroups())) {
                boolQueryBuilder2.must((QueryBuilder)EsPageQueryUtils.getQueryBuilderByGroups(searchModel.getAuthorizationGroups()));
            }
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2);
            boolQueryBuilder.must((QueryBuilder)hasChildQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static List<List<SearchFilter>> mergeGroups(List<List<SearchFilter>> groupsA, List<List<SearchFilter>> groupsB) {
        LOGGER.debug("groupsA\uff1a{}", groupsA);
        LOGGER.debug("groupsB\uff1a{}", groupsB);
        if (CollectionUtils.isEmpty(groupsA)) {
            return groupsB;
        }
        if (CollectionUtils.isEmpty(groupsB)) {
            return groupsA;
        }
        ArrayList newGroups = Lists.newArrayList();
        groupsA.forEach(groupA -> groupsB.forEach(groupB -> {
            ArrayList newGroup = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)groupA) && !CollectionUtils.isEmpty((Collection)groupB)) {
                newGroup.addAll(groupA);
                newGroup.addAll(groupB);
                newGroups.add(newGroup);
            } else if (!CollectionUtils.isEmpty((Collection)groupA) && CollectionUtils.isEmpty((Collection)groupB)) {
                newGroup.addAll(groupA);
                newGroups.add(newGroup);
            } else if (CollectionUtils.isEmpty((Collection)groupA) && !CollectionUtils.isEmpty((Collection)groupB)) {
                newGroup.addAll(groupB);
                newGroups.add(newGroup);
            }
        }));
        LOGGER.debug("newGroups\uff1a{}", (Object)newGroups);
        return newGroups;
    }

    private static BoolQueryBuilder getQueryBuilderByGroups(List<List<SearchFilter>> searchGroups) {
        BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty(searchGroups)) {
            for (List<SearchFilter> searchGroup : searchGroups) {
                BoolQueryBuilder mustQuery = QueryBuilders.boolQuery();
                if (!CollectionUtils.isEmpty(searchGroups)) {
                    for (SearchFilter searchFilter : searchGroup) {
                        QueryBuilder mustQueryBuilder = EsPageQueryUtils.getQueryBuilder(searchFilter);
                        if (!Objects.nonNull(mustQueryBuilder)) continue;
                        if (Objects.equals(Operator.like.name(), searchFilter.getFieldName())) {
                            mustQuery.must(mustQueryBuilder);
                            continue;
                        }
                        mustQuery.filter(mustQueryBuilder);
                    }
                }
                shouldQuery.should((QueryBuilder)mustQuery);
            }
        }
        return shouldQuery;
    }

    private static QueryBuilder getQueryBuilder(SearchFilter searchFilter) {
        if (Objects.isNull(searchFilter)) {
            return null;
        }
        String fieldName = searchFilter.getFieldName();
        if ((fieldName = EsPageQueryUtils.camelToUnderscore(fieldName, camelToUnderscore)) == null) {
            throw new RuntimeException("searchFilter fieldName is null");
        }
        if (null == searchFilter.getFieldQueryType()) {
            throw new RuntimeException("searchFilter fieldQueryType is null");
        }
        if (Objects.isNull(searchFilter.getClazz())) {
            searchFilter.setClazz(String.class);
        }
        String searchText = "";
        List<?> value = searchFilter.getValue();
        if (CollectionUtils.isEmpty(value)) {
            if (!String.class.equals((Object)searchFilter.getClazz())) {
                searchText = "-1";
            }
        } else {
            searchText = StringUtils.toString(value.get(0));
        }
        BoolQueryBuilder query = null;
        switch (searchFilter.getFieldQueryType()) {
            case eq: {
                query = QueryBuilders.termQuery((String)fieldName, (String)searchText);
                break;
            }
            case range: {
                if (value.size() != 2) break;
                String searchText2 = StringUtils.toString(value.get(1));
                if (!EsPageQueryUtils.valueIsEmpty(searchText) && EsPageQueryUtils.valueIsEmpty(searchText2)) {
                    query = QueryBuilders.rangeQuery((String)fieldName).gte((Object)searchText);
                }
                if (EsPageQueryUtils.valueIsEmpty(searchText) && !EsPageQueryUtils.valueIsEmpty(searchText2)) {
                    query = QueryBuilders.rangeQuery((String)fieldName).lte((Object)StringUtils.toString((Object)searchText2));
                }
                if (EsPageQueryUtils.valueIsEmpty(searchText) || EsPageQueryUtils.valueIsEmpty(searchText2)) break;
                query = QueryBuilders.rangeQuery((String)fieldName).from((Object)searchText).to((Object)StringUtils.toString((Object)searchText2));
                break;
            }
            case like: {
                searchText = "*" + searchText + "*";
                query = QueryBuilders.wildcardQuery((String)fieldName, (String)searchText);
                break;
            }
            case checkbox: 
            case tree: {
                if (CollectionUtils.isEmpty(value)) {
                    query = QueryBuilders.termQuery((String)fieldName, (String)searchText);
                    break;
                }
                ArrayList values = Lists.newArrayList();
                for (Object item : value) {
                    if (EsPageQueryUtils.valueIsEmpty(item)) continue;
                    values.add(StringUtils.toString(item));
                }
                query = QueryBuilders.termsQuery((String)fieldName, (Collection)values);
                break;
            }
            case radio: {
                query = QueryBuilders.termQuery((String)fieldName, (String)searchText);
                break;
            }
            case not_in: {
                query = QueryBuilders.boolQuery();
                if (CollectionUtils.isEmpty(value)) {
                    query.mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)searchText));
                    break;
                }
                for (Object item : value) {
                    if (EsPageQueryUtils.valueIsEmpty(item)) continue;
                    query.mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)StringUtils.toString(item)));
                }
                break;
            }
            default: {
                query = QueryBuilders.termQuery((String)fieldName, (String)searchText);
            }
        }
        return query;
    }

    public static String camelToUnderscore(String fieldName, boolean camelToUnderscore) {
        if (null == fieldName || fieldName.length() == 0) {
            return "";
        }
        if (!camelToUnderscore) {
            return fieldName;
        }
        int len = fieldName.length();
        StringBuilder strb = new StringBuilder(len + len >> 1);
        for (int i = 0; i < len; ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                strb.append("_");
                strb.append(Character.toLowerCase(c));
                continue;
            }
            strb.append(c);
        }
        return strb.toString();
    }

    private static boolean valueIsEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return "".equals(value) || "".equals(value.toString().trim());
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }
}

