/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.esutils.config;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticConfig {
    @Value(value="${es7.host}")
    public String host;
    @Value(value="${es7.port}")
    public int port;
    @Value(value="${es7.scheme}")
    public String scheme;
    @Value(value="${es7.user}")
    public String esUser;
    @Value(value="${es7.pwd}")
    public String esPwd;

    @Bean
    public RestClientBuilder restClientBuilder() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esUser, this.esPwd));
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{this.makeHttpHost()}).setHttpClientConfigCallback(arg_0 -> ElasticConfig.lambda$restClientBuilder$0((CredentialsProvider)credentialsProvider, arg_0));
        return builder;
    }

    @Bean
    public RestClient elasticsearchRestClient() {
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, this.scheme)}).build();
    }

    private HttpHost makeHttpHost() {
        return new HttpHost(this.host, this.port, this.scheme);
    }

    @Bean
    public RestHighLevelClient restHighLevelClient() {
        if (Strings.isEmpty((CharSequence)this.esUser) || Strings.isEmpty((CharSequence)this.esPwd)) {
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, this.scheme)}));
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esUser, this.esPwd));
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{this.makeHttpHost()}).setHttpClientConfigCallback(arg_0 -> ElasticConfig.lambda$restHighLevelClient$1((CredentialsProvider)credentialsProvider, arg_0));
        return new RestHighLevelClient(builder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restHighLevelClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

