/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.esutils.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaseElasticService {
    private static final Logger log = LoggerFactory.getLogger(BaseElasticService.class);
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Value(value="${es.index.prefix:NONE}")
    String esIndexPrefix;

    public <T> List<T> search(String idxName, SearchSourceBuilder builder, Class<T> c) {
        idxName = this.fillPrefix(idxName);
        SearchRequest request = new SearchRequest(new String[]{idxName});
        request.source(builder);
        try {
            SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            ArrayList<Object> res = new ArrayList<Object>(hits.length);
            for (SearchHit hit : hits) {
                res.add(JSON.parseObject((String)hit.getSourceAsString(), c));
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String fillPrefix(String idxName) {
        if (Strings.isNotEmpty((CharSequence)idxName) && !"NONE".equalsIgnoreCase(this.esIndexPrefix)) {
            return this.esIndexPrefix + idxName;
        }
        return idxName;
    }

    public SearchResponse search(String idxName, SearchSourceBuilder builder) {
        idxName = this.fillPrefix(idxName);
        SearchRequest request = new SearchRequest(new String[]{idxName});
        request.source(builder);
        try {
            SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CountResponse count(String idxName, SearchSourceBuilder builder) {
        idxName = this.fillPrefix(idxName);
        CountRequest request = new CountRequest(new String[]{idxName});
        request.source(builder);
        try {
            CountResponse response = this.restHighLevelClient.count(request, RequestOptions.DEFAULT);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RefreshResponse refresh(String idxName) {
        idxName = this.fillPrefix(idxName);
        RefreshRequest request = new RefreshRequest(new String[]{idxName});
        try {
            RefreshResponse response = this.restHighLevelClient.indices().refresh(request, RequestOptions.DEFAULT);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResponse search(String idxName, SearchSourceBuilder builder, Scroll scroll) {
        idxName = this.fillPrefix(idxName);
        SearchRequest request = new SearchRequest(new String[]{idxName});
        request.scroll(scroll);
        request.source(builder);
        try {
            SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResponse scroll(String scrollId, Scroll scroll) {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
        scrollRequest.scroll(scroll);
        try {
            SearchResponse response = this.restHighLevelClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClearScrollResponse clearScroll(String scrollId) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        try {
            ClearScrollResponse clearScrollResponse = this.restHighLevelClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
            log.info(clearScrollResponse.toString());
            return clearScrollResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

