/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.esutils.utils;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticUtil {
    private static final Logger log = LoggerFactory.getLogger(ElasticUtil.class);

    private ElasticUtil() {
    }

    public static Class<?> getClazz(String clazzName) {
        try {
            return Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static SearchSourceBuilder initSearchSourceBuilder(QueryBuilder queryBuilder, int from, int size, int timeout) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(queryBuilder);
        sourceBuilder.from(from);
        sourceBuilder.size(size);
        sourceBuilder.timeout(new TimeValue((long)timeout, TimeUnit.SECONDS));
        log.info(sourceBuilder.toString());
        return sourceBuilder;
    }

    public static SearchSourceBuilder initSearchSourceBuilder(QueryBuilder queryBuilder) {
        return ElasticUtil.initSearchSourceBuilder(queryBuilder, 0, 10, 60);
    }
}

