/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.controller;

import com.xforceplus.phoenix.recog.app.utils.BaseLogTracer;
import com.xforceplus.phoenix.recog.app.utils.ErrorLogTracer;
import com.xforceplus.phoenix.recog.app.utils.OSSUtils;
import com.xforceplus.phoenix.recog.app.utils.PdfUtils;
import com.xforceplus.phoenix.recog.app.utils.TransactionalServiceBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/download"})
public class FileDownloadController
extends TransactionalServiceBase {
    public static String downloadUrl = "http://localhost:8081/download/oss";
    private String domainName = "localhost:8081";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OSSUtils ossUtils;
    @Autowired
    PdfUtils pdfUtils;

    @PostConstruct
    public void init() {
        downloadUrl = this.domainName.startsWith("http") || this.domainName.startsWith("https") ? String.format("%s/download/oss", this.domainName) : String.format("http://%s/download/oss", this.domainName);
    }

    @RequestMapping(value={"/oss"})
    public void downloadResource(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="key") String key) {
        try {
            response.setContentType("application/force-download");
            response.setHeader("Content-Transfer-Encoding", "binary");
            String filename = key;
            try {
                int lastIndexOf = key.lastIndexOf("%2F");
                lastIndexOf = lastIndexOf > 0 ? (lastIndexOf += 3) : 0;
                filename = key.substring(lastIndexOf, key.length());
            }
            catch (Exception e) {
                this.logger.error(FileDownloadController.stringifyLogTracer(ErrorLogTracer.of(e).errorCode("").message("")));
            }
            response.addHeader("Content-Disposition", "attachment; filename=" + filename);
            key = URLDecoder.decode(key, "UTF-8");
            InputStream is = this.ossUtils.getOSSFileInputStream(key);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            this.logger.error(FileDownloadController.stringifyLogTracer(ErrorLogTracer.of(e).errorCode("CPPTTY0001").message("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25")));
        }
    }

    public static String stringifyLogTracer(BaseLogTracer logTracer) {
        return logTracer.toString();
    }
}

