/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.service.impl;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import com.xforceplus.phoenix.recog.api.model.batch.MsCompleteBatchRequest;
import com.xforceplus.phoenix.recog.api.model.batch.MsCompleteBatchResponse;
import com.xforceplus.phoenix.recog.api.model.batch.MsFetchBatchIdRequest;
import com.xforceplus.phoenix.recog.api.model.batch.MsFetchBatchIdResponse;
import com.xforceplus.phoenix.recog.app.api.model.batch.CompleteBatchRequest;
import com.xforceplus.phoenix.recog.app.api.model.batch.CompleteBatchResponse;
import com.xforceplus.phoenix.recog.app.api.model.batch.FetchBatchIdResponse;
import com.xforceplus.phoenix.recog.app.client.RecBatchClient;
import com.xforceplus.phoenix.recog.app.service.RecBatchService;
import com.xforceplus.phoenix.recog.app.utils.ContextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecBatchServiceImpl
implements RecBatchService {
    private static final Logger log = LoggerFactory.getLogger(RecBatchServiceImpl.class);
    @Autowired
    private RecBatchClient recBatchClient;
    @Autowired
    private ContextUtils contextUtils;

    @Override
    public FetchBatchIdResponse fetchBatchId() {
        FetchBatchIdResponse response = new FetchBatchIdResponse();
        MsFetchBatchIdRequest msRequest = new MsFetchBatchIdRequest();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        try {
            MsFetchBatchIdResponse msResponse = this.recBatchClient.fetchBatchId(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65b0\u7684\u6279\u6b21\u53f7\u9519\u8bef", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u83b7\u53d6\u65b0\u7684\u6279\u6b21\u53f7\u9519\u8bef");
            return response;
        }
    }

    @Override
    public CompleteBatchResponse completeBatch(CompleteBatchRequest request) {
        CompleteBatchResponse response = new CompleteBatchResponse();
        List<Long> batchIds = request.getBatchIds();
        MsCompleteBatchRequest msRequest = new MsCompleteBatchRequest();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        msRequest.setBatchIds(batchIds);
        try {
            MsCompleteBatchResponse msResponse = this.recBatchClient.completeBatch(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u5b8c\u6210\u6279\u6b21\u9519\u8bef", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u5b8c\u6210\u6279\u6b21\u9519\u8bef");
            return response;
        }
    }
}

