/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.recog.api.common.Response;
import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import com.xforceplus.phoenix.recog.api.model.MsRecResponse;
import com.xforceplus.phoenix.recog.api.model.file.HierarchyAdjDto;
import com.xforceplus.phoenix.recog.api.model.file.HierarchyAdjInfo;
import com.xforceplus.phoenix.recog.api.model.file.MsCancelHookRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFileDeleteRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFileDeleteResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsFileUploadRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFileUploadRequestU;
import com.xforceplus.phoenix.recog.api.model.file.MsFileUploadResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsFindStatRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFindStatResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsFindSubmittedFilesRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFindSubmittedFilesResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsFindUnSubmitFilesRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsFindUnSubmitFilesResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsGetDataPermissionRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsGetDataPermissionResponse;
import com.xforceplus.phoenix.recog.api.model.file.MsReGenerateHierarchyRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsSubmitProcessRequest;
import com.xforceplus.phoenix.recog.api.model.file.MsSubmitRequest;
import com.xforceplus.phoenix.recog.api.model.file.SubmitProcessDto;
import com.xforceplus.phoenix.recog.api.model.invoice.FileDownLoadDto;
import com.xforceplus.phoenix.recog.api.model.invoice.MsDownLoadRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsDownLoadResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.CheckSectionRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FileDeleteRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FileDeleteResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.FileSubmitRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FileSubmitResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.FileUploadDto;
import com.xforceplus.phoenix.recog.app.api.model.file.FindStatRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FindStatResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.FindSubmittedFilesRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FindSubmittedFilesResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.FindUnSubmitFilesRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.FindUnSubmitFilesResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.GetDataPermissionRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.GetDataPermissionResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.ReGenerateHierarchyRequest;
import com.xforceplus.phoenix.recog.app.api.model.file.ReGenerateHierarchyResponse;
import com.xforceplus.phoenix.recog.app.api.model.file.SubmitProcessRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.DownLoadRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.DownLoadResponse;
import com.xforceplus.phoenix.recog.app.client.RecFileClient;
import com.xforceplus.phoenix.recog.app.service.RecFileService;
import com.xforceplus.phoenix.recog.app.utils.ContextUtils;
import com.xforceplus.phoenix.recog.app.utils.OSSUtils;
import com.xforceplus.phoenix.recog.app.utils.RecFileUtils;
import com.xforceplus.purchaser.common.utils.UUIDUtils;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RecFileServiceImpl
implements RecFileService {
    private static final Logger log = LoggerFactory.getLogger(RecFileServiceImpl.class);
    @Autowired
    private RecFileClient recFileClient;
    @Autowired
    private ContextUtils contextUtils;
    @Autowired
    OSSUtils ossUtils;

    @Override
    public MsRecResponse<Long> uploadFile(FileUploadDto uploadDto) {
        log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6");
        MsFileUploadRequest msRequest = new MsFileUploadRequest();
        BeanUtils.copyProperties((Object)uploadDto, (Object)msRequest);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        msRequest.setTags(uploadDto.getTags());
        msRequest.setFileUrl(uploadDto.getFileUrl());
        msRequest.setFileType(RecFileUtils.getFileType(uploadDto.getFileUrl()));
        MsFileUploadResponse response = null;
        try {
            log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb");
            response = this.recFileClient.uploadFile(msRequest);
            log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f");
            return response;
        }
        catch (Exception e) {
            log.error("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse<Long> uploadFileU(MultipartFile fileU, Long batchId, Long headFileId, String tagsU, int fileOrder, UserSessionInfo userSessionInfo) throws IOException {
        log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6");
        MsFileUploadRequestU msFileUploadRequestU = new MsFileUploadRequestU();
        JSONArray jsonArray = null;
        Object aList = JSON.parse((String)tagsU);
        JSONArray tags = jsonArray = JSONArray.fromObject((Object)aList.toString());
        Long userId = userSessionInfo.getSysUserId();
        Long groupId = userSessionInfo.getGroupId();
        String fileName = fileU.getOriginalFilename();
        String newFilename = UUIDUtils.shortUUID();
        String fileSuffix = FilenameUtils.getExtension((String)fileName);
        String key = this.ossUtils.putTempObjectByInputStream(newFilename + '.' + fileSuffix, fileU.getInputStream(), fileName);
        String imageUrl = this.ossUtils.putUrl(key);
        msFileUploadRequestU.setImageUrl(imageUrl);
        msFileUploadRequestU.setFileSuffix(fileSuffix);
        msFileUploadRequestU.setBatchId(batchId);
        msFileUploadRequestU.setHeadFileId(headFileId);
        msFileUploadRequestU.setTags((List)tags);
        msFileUploadRequestU.setGroupId(groupId);
        msFileUploadRequestU.setFileOrder(Integer.valueOf(fileOrder));
        msFileUploadRequestU.setUserId(userId);
        MsFileUploadResponse response = null;
        try {
            log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb");
            response = this.recFileClient.uploadFileU(msFileUploadRequestU);
            log.info("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f");
            return response;
        }
        catch (Exception e) {
            log.error("uploadFile\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u65b0\u6279\u6b21\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public ReGenerateHierarchyResponse reGenerateHierarchy(ReGenerateHierarchyRequest request) {
        ReGenerateHierarchyResponse response = new ReGenerateHierarchyResponse();
        HierarchyAdjInfo adjInfo = request.getAdjInfo();
        if (adjInfo == null || null == adjInfo.getHeadFileId() || CollectionUtils.isEmpty((Collection)adjInfo.getAddFileIds())) {
            response.setMessage("\u5c42\u7ea7\u53c2\u6570\u4e3a\u7a7a");
            response.setCode(-1);
            return response;
        }
        MsReGenerateHierarchyRequest msRequest = new MsReGenerateHierarchyRequest();
        HierarchyAdjDto hierarchyDto = new HierarchyAdjDto();
        hierarchyDto.setAdjInfos((List)Lists.newArrayList((Object[])new HierarchyAdjInfo[]{adjInfo}));
        msRequest.setHierarchyAdjDto(hierarchyDto);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        MsRecResponse msResponse = null;
        try {
            msResponse = this.recFileClient.reGenerateHierarchy(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u8c03\u6574\u5c42\u7ea7\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u8c03\u6574\u5c42\u7ea7\u5173\u7cfb\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FindUnSubmitFilesResponse findUnSubmitFiles(MsFindUnSubmitFilesRequest msRequest) {
        FindUnSubmitFilesResponse response = new FindUnSubmitFilesResponse();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        log.info(msRequest.getGroupId() + "");
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        try {
            MsFindUnSubmitFilesResponse msResponse = this.recFileClient.findUnSubmitFiles(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f85\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u67e5\u8be2\u5f85\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FindSubmittedFilesResponse findSubmittedFiles(FindSubmittedFilesRequest request) {
        FindSubmittedFilesResponse response = new FindSubmittedFilesResponse();
        MsFindSubmittedFilesRequest msRequest = new MsFindSubmittedFilesRequest();
        BeanUtils.copyProperties((Object)request, (Object)msRequest);
        MsFindSubmittedFilesRequest.QueryExtend queryExtend = new MsFindSubmittedFilesRequest.QueryExtend();
        if (request.getQueryExtend() != null) {
            queryExtend.setBizTag1(request.getQueryExtend().getBizTag1());
            queryExtend.setBizTag2(request.getQueryExtend().getBizTag2());
            queryExtend.setBizTag3(request.getQueryExtend().getBizTag3());
        }
        msRequest.setQueryExtend(queryExtend);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        try {
            MsFindSubmittedFilesResponse msResponse = this.recFileClient.findSubmittedFiles(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5df2\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u67e5\u8be2\u5df2\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FileDeleteResponse deleteFile(FileDeleteRequest request) {
        FileDeleteResponse response = new FileDeleteResponse();
        List<Long> fileIds = request.getIds();
        MsFileDeleteRequest msRequest = new MsFileDeleteRequest();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        msRequest.setIds(fileIds);
        try {
            MsFileDeleteResponse msResponse = this.recFileClient.deleteFile(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u5220\u9664\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse<?> submit() {
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u63d0\u4ea4");
        MsSubmitRequest msRequest = new MsSubmitRequest();
        MsRecResponse response = new MsRecResponse();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        try {
            response = this.recFileClient.submit(msRequest);
            long end = System.currentTimeMillis();
            log.info("\u5f00\u59cb\u5b8c\u6210");
            log.info("\u63d0\u4ea4\u8017\u65f6\uff1a" + (end - start) / 1000L + " \u79d2");
            return response;
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FileSubmitResponse submitFile(FileSubmitRequest request) {
        FileSubmitResponse response = new FileSubmitResponse();
        MsSubmitRequest msRequest = new MsSubmitRequest();
        msRequest.setBatchIds(request.getBatchIds());
        msRequest.setFileIds(request.getFileIds());
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        try {
            MsRecResponse msResponse = this.recFileClient.submit(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FindStatResponse findStat(FindStatRequest request) {
        FindStatResponse response = new FindStatResponse();
        Long batchId = request.getBatchId();
        Long billSeq = request.getBillSeq();
        String submittedFlag = request.getSubmittedFlag();
        MsFindStatRequest msRequest = new MsFindStatRequest();
        msRequest.setBatchId(batchId);
        msRequest.setBillSeq(billSeq);
        msRequest.setSubmittedFlag(submittedFlag);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        try {
            MsFindStatResponse msResponse = this.recFileClient.findStat(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u7edf\u8ba1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u67e5\u627e\u7edf\u8ba1\u4fe1\u606f\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse<SubmitProcessDto> submitProcess(SubmitProcessRequest request) {
        MsRecResponse response = new MsRecResponse();
        MsSubmitProcessRequest msRequest = new MsSubmitProcessRequest();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        try {
            return this.recFileClient.submitProcess(msRequest);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u63d0\u4ea4\u8fdb\u5ea6\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u67e5\u8be2\u63d0\u4ea4\u8fdb\u5ea6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public DownLoadResponse downLoadFiles(DownLoadRequest request) {
        DownLoadResponse response = new DownLoadResponse();
        List<FileDownLoadDto> files = request.getFiles();
        MsDownLoadRequest msRequest = new MsDownLoadRequest();
        msRequest.setFiles(files);
        msRequest.setUserId(this.contextUtils.userIdNullas0());
        msRequest.setGroupId(this.contextUtils.groupIdNullAs0());
        try {
            MsDownLoadResponse msResponse = this.recFileClient.downLoadFiles(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public FindUnSubmitFilesResponse findUnSubmitFilesByRedis(FindUnSubmitFilesRequest request) {
        FindUnSubmitFilesResponse response = new FindUnSubmitFilesResponse();
        MsFindUnSubmitFilesRequest msRequest = new MsFindUnSubmitFilesRequest();
        BeanUtils.copyProperties((Object)request, (Object)msRequest);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        try {
            MsFindUnSubmitFilesResponse msResponse = this.recFileClient.findUnSubmitFilesByRedis(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f85\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u67e5\u8be2\u5f85\u63d0\u4ea4\u6587\u4ef6\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public GetDataPermissionResponse getDataPermission(GetDataPermissionRequest request) {
        GetDataPermissionResponse response = new GetDataPermissionResponse();
        MsGetDataPermissionRequest msRequest = new MsGetDataPermissionRequest();
        BeanUtils.copyProperties((Object)request, (Object)msRequest);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        try {
            MsGetDataPermissionResponse msResponse = this.recFileClient.getDataPermission(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u6743\u9650", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u83b7\u53d6\u6570\u636e\u6743\u9650\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse cancelHook(MsCancelHookRequest request) {
        MsRecResponse response = new MsRecResponse();
        List batchIds = request.getIds();
        MsCancelHookRequest msRequest = new MsCancelHookRequest();
        msRequest.setIds(batchIds);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        try {
            MsRecResponse msResponse = this.recFileClient.cancelHook(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u6302\u63a5\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u53d6\u6d88\u6302\u63a5\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse checkSection(CheckSectionRequest request) {
        List<OrgModel> orgList = this.contextUtils.getOrgIdList(this.contextUtils.getUserSessionInfo().getGroupId(), this.contextUtils.getUserSessionInfo().getSysUserId());
        List orgCodeList = orgList.stream().map(OrgModel::getOrgCode).collect(Collectors.toList());
        List<String> sections = request.getSections();
        MsRecResponse response = new MsRecResponse();
        if (!CollectionUtils.isEmpty(sections)) {
            for (String section : sections) {
                if (orgCodeList.contains(section)) continue;
                response.setCode(Response.FAIL);
                response.setMessage("\u90e8\u95e8:" + section + " \u4e0d\u5728\u7528\u6237\u6240\u5c5e\u90e8\u95e8\u5185");
                return response;
            }
        } else {
            response.setCode(Response.FAIL);
            response.setMessage("\u53c2\u6570\u4e3a\u7a7a");
            return response;
        }
        return response;
    }
}

