/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.service.impl;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import com.xforceplus.phoenix.recog.api.model.MsRecResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.InvoiceTaxNoDto;
import com.xforceplus.phoenix.recog.api.model.invoice.MsBizTagRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsBizTagResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.MsRecResultRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsRecResultResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateByPimRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateByPimResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateInvoiceRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateInvoiceResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateTypeRequest;
import com.xforceplus.phoenix.recog.api.model.invoice.MsUpdateTypeResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.MsVerifyInvoiceRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.BizTagRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.BizTagResponse;
import com.xforceplus.phoenix.recog.app.api.model.invoice.RecResultResponse;
import com.xforceplus.phoenix.recog.app.api.model.invoice.UpdateInvoiceRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.UpdateInvoiceResponse;
import com.xforceplus.phoenix.recog.app.api.model.invoice.UpdateTypeRequest;
import com.xforceplus.phoenix.recog.app.api.model.invoice.UpdateTypeResponse;
import com.xforceplus.phoenix.recog.app.client.RecInvoiceClient;
import com.xforceplus.phoenix.recog.app.service.RecInvoiceService;
import com.xforceplus.phoenix.recog.app.utils.ContextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecInvoiceServiceImpl
implements RecInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(RecInvoiceServiceImpl.class);
    @Autowired
    private RecInvoiceClient recInvoiceClient;
    @Autowired
    private ContextUtils contextUtils;

    @Override
    public UpdateInvoiceResponse updateInvoice(UpdateInvoiceRequest request) {
        UpdateInvoiceResponse response = new UpdateInvoiceResponse();
        List<InvoiceTaxNoDto> invoiceDtos = request.getInvoices();
        MsUpdateInvoiceRequest msRequest = new MsUpdateInvoiceRequest();
        msRequest.setInvoices(invoiceDtos);
        msRequest.setUserId(this.contextUtils.userIdNullas0());
        msRequest.setGroupId(this.contextUtils.groupIdNullAs0());
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        try {
            MsUpdateInvoiceResponse msResponse = this.recInvoiceClient.updateInvoice(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u53d1\u7968\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u4fee\u6539\u53d1\u7968\u4fe1\u606f\u9519\u8bef");
            return response;
        }
    }

    @Override
    public UpdateTypeResponse updateInvoiceType(UpdateTypeRequest request) {
        UpdateTypeResponse response = new UpdateTypeResponse();
        MsUpdateTypeRequest msRequest = new MsUpdateTypeRequest();
        msRequest.setInvoiceDtos(request.getInvoiceDtos());
        if (this.contextUtils.getUserSessionInfo() == null) {
            log.error("\u767b\u9646\u72b6\u6001\u5f02\u5e38");
            response.setCode(-1);
            response.setMessage("\u767b\u9646\u72b6\u6001\u5f02\u5e38");
            return response;
        }
        msRequest.setUserId(Long.valueOf(this.contextUtils.getUserSessionInfo().getSysUserId()));
        msRequest.setGroupId(Long.valueOf(this.contextUtils.getUserSessionInfo().getGroupId()));
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        try {
            MsUpdateTypeResponse msResponse = this.recInvoiceClient.updateInvoiceType(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)((Object)response));
            return response;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u53d1\u7968\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u4fee\u6539\u53d1\u7968\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public RecResultResponse recResult(String request) {
        RecResultResponse response = new RecResultResponse();
        MsRecResultRequest msRequest = new MsRecResultRequest();
        msRequest.setResult(request);
        Long userId = this.contextUtils.userIdNullas0();
        Long groupId = this.contextUtils.groupIdNullAs0();
        msRequest.setGroupId(groupId);
        msRequest.setUserId(userId);
        try {
            MsRecResultResponse msResponse = this.recInvoiceClient.recResult(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)((Object)response));
            return response;
        }
        catch (Exception e) {
            log.error("\u8bc6\u522b\u7ed3\u679c\u63a8\u9001\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u8bc6\u522b\u7ed3\u679c\u63a8\u9001\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public BizTagResponse updateBizTag(BizTagRequest request) {
        BizTagResponse response = new BizTagResponse();
        MsBizTagRequest msRequest = new MsBizTagRequest();
        BeanUtils.copyProperties((Object)request, (Object)msRequest);
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)msRequest);
        this.contextUtils.initOrgCodes((MsRecBaseRequest)msRequest);
        try {
            MsBizTagResponse msResponse = this.recInvoiceClient.updateBizTag(msRequest);
            return response.msResponse(msResponse, response);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5f02\u5e38", (Throwable)e);
            response.setCode(-1);
            response.setMessage("\u6279\u91cf\u66f4\u65b0\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsUpdateByPimResponse updateInvoiceByPim(MsUpdateByPimRequest request) {
        MsUpdateByPimResponse response = new MsUpdateByPimResponse();
        this.contextUtils.setUserContextInfo((MsRecBaseRequest)request);
        try {
            response = this.recInvoiceClient.updateInvoiceByPim(request);
            return response;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u53d1\u7968\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u66f4\u65b0\u53d1\u7968\u5f02\u5e38");
            return response;
        }
    }

    @Override
    public MsRecResponse verifyInvoice(MsVerifyInvoiceRequest request) {
        MsRecResponse response = new MsRecResponse();
        MsVerifyInvoiceRequest msRequest = new MsVerifyInvoiceRequest();
        msRequest.setInvoiceIds(request.getInvoiceIds());
        if (this.contextUtils.getUserSessionInfo() == null) {
            log.error("\u767b\u9646\u72b6\u6001\u5f02\u5e38");
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u767b\u9646\u72b6\u6001\u5f02\u5e38");
            return response;
        }
        msRequest.setUserId(Long.valueOf(this.contextUtils.getUserSessionInfo().getSysUserId()));
        msRequest.setGroupId(Long.valueOf(this.contextUtils.getUserSessionInfo().getGroupId()));
        this.contextUtils.doRequst((MsRecBaseRequest)msRequest);
        try {
            MsRecResponse msResponse = this.recInvoiceClient.verifyInvoice(msRequest);
            BeanUtils.copyProperties((Object)msResponse, (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u53d1\u7968\u9a8c\u771f\u5f02\u5e38", (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMessage("\u53d1\u8d77\u53d1\u7968\u9a8c\u771f\u5f02\u5e38");
            return response;
        }
    }
}

