/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.phoenix.recog.api.model.MSUserRequest;
import com.xforceplus.phoenix.recog.api.model.MsCompanyModel;
import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import com.xforceplus.phoenix.recog.app.client.ComClient;
import com.xforceplus.phoenix.recog.app.client.OrgClient;
import com.xforceplus.phoenix.recog.app.client.UserClient;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.MSResponse;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);
    public static final Long SYS_USER_ID = 0L;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    private static final Logger logger = LoggerFactory.getLogger(ContextUtils.class);
    @Autowired
    OrgClient orgClient;
    @Autowired
    ComClient comClient;
    @Autowired
    UserClient userClient;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;

    public void initOrgCodes(MsRecBaseRequest request) {
        List<OrgModel> orgList = this.getOrgIdList(this.getUserSessionInfo().getGroupId(), this.getUserSessionInfo().getSysUserId());
        List orgCodeList = orgList.stream().map(OrgModel::getOrgCode).collect(Collectors.toList());
        request.setOrgCodes(orgCodeList);
    }

    public List<OrgModel> getOrgIdList(Long groupId, Long userId) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u7ec4\u7ec7groupId:" + this.groupIdNullAs0());
        ArrayList orgIdList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("recog");
        clientRequest.setRid(UUID.randomUUID().toString());
        clientRequest.setGroupID(groupId);
        clientRequest.setUserID(userId);
        this.getOrgIdList(clientRequest, 1, 1000, orgIdList);
        logger.info("\u83b7\u53d6\u6743\u9650\u7ec4\u7ec7\u5217\u8868\u7ed3\u679c\uff0corgIdList\uff1a{} ,groupId:{},userId:{}", new Object[]{orgIdList, groupId, userId});
        return orgIdList;
    }

    private List<OrgModel> getOrgIdList(GetOrgListRequest clientRequest, int page, int rowNum, List<OrgModel> orgIdList) {
        clientRequest.setPage(Integer.valueOf(page));
        clientRequest.setRow(Integer.valueOf(rowNum));
        UserInfo userInfo = new UserInfo();
        userInfo.setGroupId(clientRequest.getGroupID().longValue());
        this.userInfoHolder.put((Object)userInfo);
        long start = System.currentTimeMillis();
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        long end = System.currentTimeMillis();
        logger.info("getOrgIdList:input param: {} return value: {},\u8017\u65f6\uff1a{}", new Object[]{clientRequest, clientResponse, start - end});
        if (clientResponse == null || clientResponse.getCode() != 1) {
            return orgIdList;
        }
        List orgModelList = clientResponse.getResult();
        if (CollectionUtils.isEmpty((Collection)orgModelList)) {
            return orgIdList;
        }
        orgIdList.addAll(orgModelList);
        if (clientResponse.getTotal() > (long)orgIdList.size()) {
            this.getOrgIdList(clientRequest, page + 1, rowNum, orgIdList);
        }
        return orgIdList;
    }

    private List<CompanyModel> getTaxMumList(Long groupId) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u7a0e\u53f7groupId:" + this.groupIdNullAs0());
        SearchCompanyListRequest request = new SearchCompanyListRequest();
        request.setAppid("recog");
        request.setRid(UUID.randomUUID().toString());
        request.setGroupId(groupId);
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(1000));
        UserInfo userInfo = new UserInfo();
        userInfo.setGroupId(groupId.longValue());
        this.userInfoHolder.put((Object)userInfo);
        logger.info("getTaxMumList\u7ec4\u88c5\u4e0a\u4e0b\u6587\uff0cuserInfoHolder.get():{}", this.userInfoHolder.get());
        SearchCompanyListResponse response = this.comClient.searchCompanyList(request);
        if (response == null || response.getCode() != 1) {
            return new ArrayList<CompanyModel>();
        }
        return response.getResult();
    }

    public void doRequst(MsRecBaseRequest request) {
        List<Object> orgIds = new ArrayList();
        HashMap<String, MsCompanyModel> taxs = new HashMap<String, MsCompanyModel>();
        HashMap taxsGroup = new HashMap();
        CompletableFuture<List> future1 = CompletableFuture.supplyAsync(() -> {
            log.info("task1 doing...");
            List<OrgModel> ListOrg = this.getOrgIdList(request.getGroupId(), request.getUserId());
            return ListOrg;
        });
        CompletableFuture<List> future2 = CompletableFuture.supplyAsync(() -> {
            log.info("task2 doing...");
            List<CompanyModel> listCom = this.getTaxMumList(request.getGroupId());
            for (CompanyModel com : listCom) {
                MsCompanyModel model = new MsCompanyModel();
                BeanUtils.copyProperties((Object)com, (Object)model);
                taxsGroup.put(com.getTaxNum(), model);
            }
            return listCom;
        });
        CompletableFuture<List> future3 = CompletableFuture.supplyAsync(() -> {
            List taxNumSet = Lists.newArrayList();
            log.info("task3 doing...");
            MSUserRequest userRequest = new MSUserRequest();
            userRequest.setUserId(request.getUserId());
            userRequest.setExtraInfo(Integer.valueOf(8));
            MSResponse userInfo = this.userClient.getUserTaxNum(userRequest);
            if (userInfo.getResult() != null) {
                taxNumSet = (List)userInfo.getResult();
            }
            return taxNumSet;
        });
        CompletableFuture<Void> allResult = CompletableFuture.allOf(future1, future2, future3);
        allResult.join();
        List orgModelList = Lists.newArrayList();
        List companyModelList = Lists.newArrayList();
        List taxNumSet = Lists.newArrayList();
        try {
            orgModelList = future1.get();
            companyModelList = future2.get();
            taxNumSet = future3.get();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u63a5\u53e3\u9519\u8bef:{}", (Throwable)e);
            throw new RuntimeException("\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u63a5\u53e3\u9519\u8bef");
        }
        orgIds = orgModelList.stream().map(OrgModel::getOrgStructId).collect(Collectors.toList());
        for (OrgModel org : orgModelList) {
            for (CompanyModel com : companyModelList) {
                if (!CommonUtils.isEdit((Long)org.getCompanyId()) || !CommonUtils.isEdit((Long)com.getCompanyId()) || !org.getCompanyId().equals(com.getCompanyId())) continue;
                MsCompanyModel model = new MsCompanyModel();
                BeanUtils.copyProperties((Object)com, (Object)model);
                taxs.put(model.getTaxNum(), model);
            }
        }
        for (String taxNum : taxNumSet) {
            if (taxs.containsKey(taxNum)) continue;
            taxs.put(taxNum, new MsCompanyModel());
        }
        logger.info("task1\u7eaf\u7cb9\u83b7\u53d6\u7ec4\u7ec7\uff0corgs:{}", (Object)JSONObject.toJSONString(orgModelList));
        logger.info("task3\u6839\u636e\u7528\u6237\u67e5\u7a0e\u53f7\uff0ctaxs\uff1a{}", (Object)JSONObject.toJSONString(taxNumSet));
        logger.info("task2\u83b7\u53d6\u6743\u9650\u7ec4\u7ec7\u5217\u8868tax\u7ed3\u679c\uff0ctaxsGroup\uff1a{}", taxsGroup);
        request.setOrgIds(orgIds);
        request.setTaxsMap(taxs);
        request.setTaxsMapGroup(taxsGroup);
    }

    public UserContext getUserInfo() {
        return (UserContext)this.contextHolder.get();
    }

    public UserSessionInfo getUserSessionInfo() {
        if (this.getUserInfo() != null) {
            return this.getUserInfo().getUserSessionInfo();
        }
        return null;
    }

    public Long getUserId() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getSysUserId();
        }
        return null;
    }

    public Long getGroupId() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupId();
        }
        return null;
    }

    public String getGroupName() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupName();
        }
        return null;
    }

    public String getGroupCode() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupCode();
        }
        return null;
    }

    public String getUserName() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getSysUserName();
        }
        return null;
    }

    public Long userIdNullas0() {
        if (this.getUserId() == null) {
            return SYS_USER_ID;
        }
        return this.getUserId();
    }

    public Long groupIdNullAs0() {
        return this.getGroupId() == null ? 0L : this.getGroupId();
    }

    public String userNameNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getUserName()) ? "" : this.getUserName();
    }

    public String groupNameNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getGroupName()) ? "GROUP" : this.getGroupName();
    }

    public String groupCodeNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getGroupCode()) ? "" : this.getGroupCode();
    }

    public void setUserContextInfo(MsRecBaseRequest request) {
        request.setUserId(this.userIdNullas0());
        request.setCreateUser(this.userNameNullAsEmpty());
        request.setGroupId(this.groupIdNullAs0());
        request.setGroupName(this.groupNameNullAsEmpty());
        request.setGroupCode(this.groupCodeNullAsEmpty());
    }
}

