/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATEDETAIL_PATTERN = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String DATE8_PATTERN = "yyyyMMdd";
    public static final String DATE10_PATTERN = "yyyy-MM-dd";
    public static final String TIME6_PATTERN = "HHmmss";
    public static final String TIME8_PATTERN = "HH:mm:ss";
    public static final String DATETIME14_PATTERN = "yyyyMMddHHmmss";
    public static final String DATETIME19_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEMSEL17_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String DATEMSEL18_PATTERN = "yyyyMMddHHmmssSSSS";
    public static Date DefaultDate = null;

    private static SimpleDateFormat getDateParser(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Date curDate() {
        return new Date();
    }

    public static String curDateStr(String strFormat) {
        Date date = new Date();
        return DateUtils.getDateParser(strFormat).format(date);
    }

    public static String curDateStr() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static Timestamp curTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static Date toDate(String dateString, String pattern) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(pattern).parse(dateString);
            return date;
        }
        catch (Exception var4) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var4);
            return null;
        }
    }

    public static Date toDate(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd").parse(dateString);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").parse(dateString);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static Date toDetailDateTime(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(DEFAULT_DATEDETAIL_PATTERN).parse(dateString);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static String toDateStr(Date date, String pattern) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser(pattern).format(date);
    }

    public static String toDateStr(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String toDateTimeStr(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String curDateStr8() {
        Date date = new Date();
        return DateUtils.getDateParser(DATE8_PATTERN).format(date);
    }

    public static String curDateStr10() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String curDateTimeStr14() {
        Date date = new Date();
        return DateUtils.getDateParser(DATETIME14_PATTERN).format(date);
    }

    public static String curDateTimeStr19() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String curDateTimeStr23() {
        Date date = new Date();
        return DateUtils.getDateParser(DEFAULT_DATEDETAIL_PATTERN).format(date);
    }

    public static String curTimeStr6() {
        Date date = new Date();
        return DateUtils.getDateParser(TIME6_PATTERN).format(date);
    }

    public static String curDateMselStr17() {
        Date date = new Date();
        return DateUtils.getDateParser(DATEMSEL17_PATTERN).format(date);
    }

    public static String curDateMselStr18() {
        Date date = new Date();
        return DateUtils.getDateParser(DATEMSEL18_PATTERN).format(date);
    }

    public static Date toDate8(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(DATE8_PATTERN).parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDate10(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime14(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(DATETIME14_PATTERN).parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime19(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            log.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static String toDateStr8(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser(DATE8_PATTERN).format(date);
    }

    public static String toDateStr10(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String toDateTimeStr14(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser(DATETIME14_PATTERN).format(date);
    }

    public static String toDateTimeStr19(Date date) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date addDays(Date date, int days) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56denull");
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static boolean isDateBetween(Date date, Date date1, Date date2) {
        return !(!date1.before(date) && !date1.equals(date) || !date.before(date2) && !date.equals(date2));
    }

    public static int getDaysInterval(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null) {
            long timeInterval = toDate.getTime() - fromDate.getTime();
            int daysInterval = (int)(timeInterval / 86400000L);
            return daysInterval;
        }
        log.warn("getDaysInterval\u65f6,\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c0");
        return 0;
    }

    public static int getWeekOfYear(Date date) {
        if (date == null) {
            log.warn("\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c-1");
            return -1;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int week = calendar.get(3);
        return week;
    }

    public static int getDayOfWeek(Date date) {
        if (date == null) {
            log.warn("\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c-1");
            return -1;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(7);
        if (0 == --day) {
            day = 7;
        }
        return day;
    }

    public static Date getLastDayInMonth(Date date) {
        return DateUtils.getLastDayInMonth(date, 0);
    }

    public static Date getLastDayInNextMonth(Date date) {
        return DateUtils.getLastDayInMonth(date, 1);
    }

    public static Date getLastDayInMonth(Date date, int i) {
        if (date == null) {
            log.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56denull");
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(2, i + 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static String toDateTime(long times) {
        long hours = (times /= 1000L) / 3600L;
        long minutes = (times -= hours * 3600L) / 60L;
        String result = hours + "(h) " + minutes + "(m) " + (times -= minutes * 60L) + "(s)";
        return result;
    }

    public static String dateDiff(String startTime, String endTime, String format) throws Exception {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        long diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
        return DateUtils.dateDiff(diff);
    }

    public static String dateDiff(String startTime, String endTime) throws Exception {
        return DateUtils.dateDiff(startTime, endTime, DATETIME14_PATTERN);
    }

    public static String dateDiff(String startTime) throws Exception {
        return DateUtils.dateDiff(startTime, DateUtils.curDateTimeStr14(), DATETIME14_PATTERN);
    }

    public static String dateDiff(Date startTime, Date endTime) {
        long diff = endTime.getTime() - startTime.getTime();
        return DateUtils.dateDiff(diff);
    }

    public static String dateDiff(long millisecond) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = millisecond / nd;
        long hour = millisecond % nd / nh;
        long min = millisecond % nd % nh / nm;
        long sec = millisecond % nd % nh % nm / ns;
        String ret = "";
        if (sec > 0L) {
            ret = sec + "\u79d2";
        }
        ret = min + "\u5206" + ret;
        if (hour > 0L) {
            ret = hour + "\u5c0f\u65f6" + ret;
        }
        if (day > 0L) {
            ret = day + "\u5929" + ret;
        }
        return ret;
    }

    public static Timestamp toTimestamp(String recReviseTime) {
        try {
            if (recReviseTime != null && !"".equals(recReviseTime.trim())) {
                return new Timestamp(Objects.requireNonNull(DateUtils.toDateTime(recReviseTime)).getTime());
            }
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
        return null;
    }

    public static int compare(String time1, String time2, String format) throws Exception {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        long diff = sd.parse(time1).getTime() - sd.parse(time2).getTime();
        return Long.compare(diff, 0L);
    }

    public static String getTime17() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEMSEL17_PATTERN);
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }
}

