/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.xforceplus.phoenix.recog.app.utils.BaseLogTracer;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorLogTracer
extends BaseLogTracer {
    private String errorCode = "";
    private String exceptionName = "";
    private String exceptionStackTrace = "";
    private String errorMessage = "";

    private ErrorLogTracer(Exception e) {
        this.errorMessage = e.getMessage();
        this.exceptionName = e.getClass().getSimpleName();
        this.exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
    }

    public static ErrorLogTracer of(Exception exception) {
        return new ErrorLogTracer(exception);
    }

    public ErrorLogTracer errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Override
    public String getTag() {
        return "EL";
    }

    @Override
    public String toString() {
        StringBuilder sb = super.toStringBuilder();
        sb.append("errorCode=").append(this.errorCode).append(",");
        sb.append("exceptionName=").append(this.exceptionName).append(",");
        sb.append("errorMessage=").append(this.errorMessage).append(",");
        sb.append("exceptionStackTrace=").append(this.exceptionStackTrace);
        return sb.toString();
    }
}

