/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.xforceplus.phoenix.recog.app.utils.EnumStringValue;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public enum FileType implements EnumStringValue
{
    PDF("pdf"),
    JPG("jpg"),
    JPEG("jpeg"),
    PNG("png");

    private final String value;
    private final String dotValue;

    private FileType(String value) {
        this.value = value;
        this.dotValue = '.' + value;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String dotValue() {
        return this.dotValue;
    }

    public String concatFilePath(String fileDir, String fileBasename) {
        if (fileDir.endsWith(File.separator)) {
            return fileDir + fileBasename + this.dotValue;
        }
        return fileDir + File.separator + fileBasename + this.dotValue;
    }

    public static boolean isPdfFile(String filename) {
        return StringUtils.isNotEmpty((CharSequence)filename) && filename.endsWith(PDF.dotValue());
    }
}

