/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.phoenix.recog.app.config.OSSSettings;
import com.xforceplus.phoenix.recog.app.utils.DateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OSSUtils {
    public static String downloadUrl = "http://localhost:8081/download/oss";
    @Autowired
    private OSSSettings ossSettings;
    public static final String DEFAULT_URL_ENCODE = "UTF-8";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String accessId = "Z2nVA9OmlwdtWaD6";
    private String accessKey = "W4oMLiIn43APTVu6RfpBRtCMubug8a";
    private String ossEndpoint = "http://oss-cn-hangzhou.aliyuncs.com/";
    private String bucketName = "phoenix-normal";
    private OSSClient client = null;

    @PostConstruct
    public void init() {
        this.accessId = this.ossSettings.getAccessId();
        this.accessKey = this.ossSettings.getAccessKey();
        this.ossEndpoint = this.ossSettings.getOssEndpoint();
        this.bucketName = this.ossSettings.getBucketName();
        this.client = new OSSClient(this.ossEndpoint, this.accessId, this.accessKey);
    }

    public InputStream getOSSFileInputStream(String key) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        OSSObject ossObject = this.client.getObject(getObjectRequest);
        InputStream in = ossObject.getObjectContent();
        return in;
    }

    public void putObject(String key, String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        FileInputStream content = new FileInputStream(file);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(file.length());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("folderName", "20160307");
        meta.setUserMetadata(map);
        PutObjectResult result = this.client.putObject(this.bucketName, key, (InputStream)content, meta);
        System.out.println(result.getETag());
    }

    public String putTempObjectByInputStream(String key, InputStream content, String fileName) throws FileNotFoundException {
        String dayName = DateUtils.getTime17();
        String pathKey = String.format("melete-scan/TEST/global/%s/%s", dayName, key);
        this.putObjectByInputStream(pathKey, content, fileName);
        return pathKey;
    }

    public void putObjectByInputStream(String key, InputStream content, String fileName) throws FileNotFoundException {
        this.logger.info("\u6587\u4ef6\u6d41\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb-----\uff01");
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(OSSUtils.getcontentType(fileName.substring(fileName.lastIndexOf("."))));
        PutObjectResult result = this.client.putObject(this.bucketName, key, content, meta);
        this.logger.info("\u4e0a\u4f20\u8fd4\u56deobject\u5bf9\u8c61====\uff01", (Object)result.getETag());
        System.out.println(result.getETag());
    }

    public static String getcontentType(String FilenameExtension) {
        if (FilenameExtension.equalsIgnoreCase(".bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equalsIgnoreCase(".gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equalsIgnoreCase(".jpeg") || FilenameExtension.equalsIgnoreCase(".jpg") || FilenameExtension.equalsIgnoreCase(".png")) {
            return "image/jpg";
        }
        if (FilenameExtension.equalsIgnoreCase(".html")) {
            return "text/html";
        }
        if (FilenameExtension.equalsIgnoreCase(".txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equalsIgnoreCase(".pdf")) {
            return "application/pdf";
        }
        if (FilenameExtension.equalsIgnoreCase(".vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equalsIgnoreCase(".pptx") || FilenameExtension.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equalsIgnoreCase(".docx") || FilenameExtension.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equalsIgnoreCase(".xml")) {
            return "text/xml";
        }
        return "image/jpg";
    }

    public void downLoadToLocalPath(String key, String localKey) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        ObjectMetadata objectMetadata = this.client.getObject(getObjectRequest, new File(localKey));
    }

    public String putUrl(String key) {
        String url = String.format("http://%s.oss-cn-hangzhou.aliyuncs.com/%s", this.bucketName, key);
        System.out.println(url);
        return url;
    }
}

