/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.lowagie.text.DocumentException;
import com.xforceplus.phoenix.recog.app.utils.FileToolsU;
import com.xforceplus.phoenix.recog.app.utils.FileType;
import com.xforceplus.phoenix.recog.app.utils.OSSUtils;
import com.xforceplus.phoenix.recog.app.utils.UUIDUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
public class PdfUtils {
    private static final Logger logger = LoggerFactory.getLogger(PdfUtils.class);
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    @Autowired
    private FileToolsU fileTools;
    @Autowired
    protected ResourceLoader resourceLoader;
    @Autowired
    private OSSUtils ossUtils;

    public String createTempPDF(File file) {
        String outputFile = this.fileTools.getTempFileName(UUIDUtils.shortUUID(), ".pdf");
        this.fileTools.createFile(outputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.createPDF(file, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return outputFile;
    }

    public String createTempPDF(String fileContent, String fileName) {
        String outputFile = this.fileTools.getTempFileName(fileName, ".pdf");
        this.fileTools.createFile(outputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.createPDF(fileContent, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDF(File file, OutputStream os) throws IOException, DocumentException {
        String outputFile = this.fileTools.getTempFileName("tmpFontFile", ".ttc");
        this.fileTools.createFile(outputFile);
        File out = new File(outputFile);
        ITextRenderer render = this.buildiTextRenderer(out);
        render.setDocument(file.toURI().toURL().toString());
        render.layout();
        try {
            render.createPDF(os);
        }
        catch (DocumentException e) {
            logger.error("\u521b\u5efapdf\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                os.close();
                FileUtils.deleteDirectory((File)new File(out.getParent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDF(String fileContent, OutputStream os) throws IOException, DocumentException {
        String outputFile = this.fileTools.getTempFileName("tmpFontFile", ".ttc");
        this.fileTools.createFile(outputFile);
        File out = new File(outputFile);
        ITextRenderer render = this.buildiTextRenderer(out);
        render.setDocumentFromString(fileContent);
        render.layout();
        try {
            render.createPDF(os);
        }
        catch (DocumentException e) {
            logger.error("\u521b\u5efapdf\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                os.close();
                FileUtils.deleteDirectory((File)new File(out.getParent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ITextRenderer buildiTextRenderer(File file) throws DocumentException, IOException {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        InputStream is = this.getClass().getResourceAsStream("/pdftemplate/simsun.ttc");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
        fontResolver.addFont(file.getAbsolutePath(), "Identity-H", false);
        return render;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parsePdfFirstPageToImage(File pdf, FileType fileType) throws IOException {
        PDDocument document;
        BufferedImage bufferedImage;
        String ossUrl;
        block13: {
            ossUrl = null;
            bufferedImage = null;
            document = null;
            try {
                String pdfBasename = FilenameUtils.getBaseName((String)pdf.getName());
                document = PDDocument.load((File)pdf);
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                bufferedImage = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
                File image = new File(fileType.concatFilePath(TEMP_DIR, pdfBasename));
                ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)image.getAbsolutePath(), (int)300);
                FileInputStream is = new FileInputStream(image);
                if (image != null) {
                    logger.info("[parsePdfFirstPageToImage] image_path: {}, image_deleted: {}", (Object)image.getAbsolutePath(), (Object)image.delete());
                }
                if (document == null) break block13;
            }
            catch (Exception e) {
                logger.error("pdf convert image exception:{}", (Throwable)e);
                return ossUrl;
            }
            try {
                document.close();
            }
            catch (IOException e) {
                logger.error("{}", (Throwable)e);
            }
        }
        PdfUtils.disposeBufferImage(bufferedImage);
        return ossUrl;
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    logger.error("{}", (Throwable)e);
                }
            }
            PdfUtils.disposeBufferImage(bufferedImage);
        }
    }

    public static void disposeBufferImage(BufferedImage bufferedImage) {
        try {
            Graphics graphics;
            if (bufferedImage != null && (graphics = bufferedImage.getGraphics()) != null) {
                graphics.dispose();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

