/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.recog.app.api.model.file.PdfTransDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class RecFileUtils {
    private static final Logger log = LoggerFactory.getLogger(RecFileUtils.class);
    @Value(value="${pdftrans.url}")
    private String pdfTransUrl;
    @Autowired
    private RestTemplate restTemplate;

    public static String getFileType(String extension, String fileUrl) {
        if (StringUtils.isEmpty((String)extension)) {
            return RecFileUtils.getExtensionFromUrl(fileUrl);
        }
        if (extension.length() >= 4) {
            return extension.substring(0, 4);
        }
        return extension;
    }

    public static String getFileType(String fileUrl) {
        return RecFileUtils.getExtensionFromUrl(fileUrl);
    }

    public static String getExtensionFromUrl(String fileUrl) {
        if (StringUtils.isEmpty((String)fileUrl)) {
            return "";
        }
        int lastDot = fileUrl.lastIndexOf(".");
        if (lastDot == -1) {
            return "";
        }
        String extension = fileUrl.substring(lastDot);
        if (".".equals(extension)) {
            return "";
        }
        return extension.substring(1, extension.length() > 5 ? 5 : extension.length());
    }

    public String getFileHandleUrl(String fileUrl) {
        if (!"pdf".equalsIgnoreCase(RecFileUtils.getExtensionFromUrl(fileUrl))) {
            return fileUrl;
        }
        PdfTransDto pdfTransDto = new PdfTransDto();
        pdfTransDto.setPdfPathList(Lists.newArrayList((Object[])new String[]{fileUrl}));
        HttpEntity requestEntity = new HttpEntity((Object)pdfTransDto, (MultiValueMap)RecFileUtils.getHttpHeaders());
        log.debug("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pdfTransDto));
        try {
            PdfTransDto result = (PdfTransDto)this.restTemplate.postForEntity(this.pdfTransUrl, (Object)requestEntity, PdfTransDto.class, new Object[0]).getBody();
            if (null != result) {
                List<String> imgs = result.getImagePathList();
                if (!CollectionUtils.isEmpty(imgs)) {
                    return imgs.get(0);
                }
                log.warn("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u8fd4\u56de\u7a7a\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)result));
                return "";
            }
            log.warn("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u8fd4\u56de\u7a7a\uff0c\u8fd4\u56de\u7ed3\u679c\uff1anull");
            return "";
        }
        catch (RestClientException e) {
            log.error("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }

    public Map<String, String> getFileHandleUrls(List<String> fileUrls) {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(fileUrls)) {
            return urlMap;
        }
        for (String fileUrl : fileUrls) {
            urlMap.put(fileUrl, "pdf".equalsIgnoreCase(RecFileUtils.getExtensionFromUrl(fileUrl)) ? "" : fileUrl);
        }
        List<String> toTransUrl = fileUrls.stream().filter(furl -> "pdf".equalsIgnoreCase(RecFileUtils.getExtensionFromUrl(furl))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(toTransUrl)) {
            return urlMap;
        }
        List<String> transedUrl = this.invokePdfToImg(toTransUrl);
        if (toTransUrl.size() != transedUrl.size()) {
            log.error("pdf\u8f6c\u6362\u4e3a\u56fe\u7247\uff0c\u9700\u8981\u8f6c\u6362{}\u5f20\uff0c\u5b9e\u9645\u8f6c\u6362\u8fd4\u56de{}\u5f20\uff0c\u8f6c\u56fe\u7247\u5931\u8d25", new Object[]{toTransUrl.size(), transedUrl.size(), new RuntimeException("pdf\u8f6c\u56fe\u7247\u5931\u8d25")});
            return urlMap;
        }
        for (int i = 0; i < toTransUrl.size(); ++i) {
            String url1 = toTransUrl.get(i);
            String url2 = transedUrl.get(i);
            if (StringUtils.isEmpty((String)url1)) continue;
            urlMap.put(url1, url2);
        }
        return urlMap;
    }

    public List<String> invokePdfToImg(List<String> fileUrls) {
        ArrayList<String> fileUrlHandles = new ArrayList<String>();
        if (CollectionUtils.isEmpty(fileUrls)) {
            return fileUrlHandles;
        }
        ArrayList<String> toHandleUrls = new ArrayList<String>();
        for (String fileUrl : fileUrls) {
            if (!"pdf".equalsIgnoreCase(RecFileUtils.getExtensionFromUrl(fileUrl))) continue;
            toHandleUrls.add(fileUrl);
        }
        if (CollectionUtils.isEmpty(toHandleUrls)) {
            return fileUrls;
        }
        PdfTransDto pdfTransDto = new PdfTransDto();
        pdfTransDto.setPdfPathList(toHandleUrls);
        HttpEntity requestEntity = new HttpEntity((Object)pdfTransDto, (MultiValueMap)RecFileUtils.getHttpHeaders());
        log.debug("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pdfTransDto));
        try {
            PdfTransDto result = (PdfTransDto)this.restTemplate.postForEntity(this.pdfTransUrl, (Object)requestEntity, PdfTransDto.class, new Object[0]).getBody();
            log.debug("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u8fd4\u56de\u53c2\u503c\uff1a{}", (Object)JSON.toJSONString((Object)result));
            if (null != result) {
                List<String> imgs = result.getImagePathList();
                if (!CollectionUtils.isEmpty(imgs)) {
                    fileUrlHandles.addAll(imgs);
                } else {
                    log.warn("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u8fd4\u56de\u7a7a\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)result));
                }
                return fileUrlHandles;
            }
            log.warn("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u8fd4\u56de\u7a7a\uff0c\u8fd4\u56de\u7ed3\u679c\uff1anull");
            return fileUrlHandles;
        }
        catch (RestClientException e) {
            log.error("\u8c03\u7528pdf\u8f6c\u56fe\u7247\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return fileUrlHandles;
        }
    }

    public static HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return headers;
    }
}

