/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class UUIDUtils {
    private static final char[] DICTIONARY_16 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] DICTIONARY_32 = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] DICTIONARY_62 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] DICTIONARY_89 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '+', '\"', '@', '*', '#', '%', '&', '/', '|', '(', ')', '=', '?', '~', '[', ']', '{', '}', '$', '-', '_', '.', ':', ',', ';', '<', '>'};
    protected static char[] dictionary = DICTIONARY_62;
    static final Map<Character, Integer> digitMap = new HashMap<Character, Integer>();
    private static final int MAX_RADIX;
    private static final int MIN_RADIX = 2;

    private static String toString(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > MAX_RADIX) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        int charPos = 64;
        char[] buf = new char[65];
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = DICTIONARY_62[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = DICTIONARY_62[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    private static long toNumber(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw UUIDUtils.forInputString(s);
                }
                if (len == 1) {
                    throw UUIDUtils.forInputString(s);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                Integer digit;
                if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null) {
                    throw UUIDUtils.forInputString(s);
                }
                if (digit < 0) {
                    throw UUIDUtils.forInputString(s);
                }
                if (result < multmin) {
                    throw UUIDUtils.forInputString(s);
                }
                if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                    throw UUIDUtils.forInputString(s);
                }
                result -= (long)digit.intValue();
            }
            return negative ? result : -result;
        }
        throw UUIDUtils.forInputString(s);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return UUIDUtils.toString(hi | val & hi - 1L, MAX_RADIX).substring(1);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 65; ++i) {
            int random = new Random().nextInt(1);
            char c = DICTIONARY_62[random];
            System.out.println("\u968f\u673a = " + random);
            System.out.println("c = " + c);
        }
    }

    public static String getUUID(BigInteger value) {
        ArrayList<Character> result = new ArrayList<Character>();
        BigInteger base = new BigInteger("" + dictionary.length);
        int exponent = 1;
        BigInteger remaining = value;
        while (true) {
            BigInteger a = base.pow(exponent);
            BigInteger b = remaining.mod(a);
            BigInteger c = base.pow(exponent - 1);
            BigInteger d = b.divide(c);
            result.add(Character.valueOf(dictionary[d.intValue()]));
            remaining = remaining.subtract(b);
            if (remaining.equals(BigInteger.ZERO)) {
                StringBuffer sb = new StringBuffer();
                for (int i = result.size() - 1; i >= 0; --i) {
                    sb.append(result.get(i));
                }
                return sb.toString();
            }
            ++exponent;
        }
    }

    public static BigInteger parseUUID(String str) {
        char[] chars = new char[str.length()];
        str.getChars(0, str.length(), chars, 0);
        char[] chars2 = new char[str.length()];
        int i = chars2.length - 1;
        char[] var4 = chars;
        int j = chars.length;
        for (int var6 = 0; var6 < j; ++var6) {
            char c = var4[var6];
            chars2[i--] = c;
        }
        HashMap<Character, BigInteger> dictMap = new HashMap<Character, BigInteger>();
        j = 0;
        for (char c : dictionary) {
            dictMap.put(Character.valueOf(c), new BigInteger("" + j++));
        }
        BigInteger bi = BigInteger.ZERO;
        BigInteger base = new BigInteger("" + dictionary.length);
        int exponent = 0;
        char[] var20 = chars2;
        int var10 = chars2.length;
        for (int var11 = 0; var11 < var10; ++var11) {
            char c = var20[var11];
            BigInteger a = (BigInteger)dictMap.get(Character.valueOf(c));
            BigInteger b = base.pow(exponent).multiply(a);
            bi = bi.add(new BigInteger("" + b));
            ++exponent;
        }
        return bi;
    }

    public static String shortUUID() {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        sb.append(UUIDUtils.digits(uuid.getMostSignificantBits() >> 32, 8));
        sb.append(UUIDUtils.digits(uuid.getMostSignificantBits() >> 16, 4));
        sb.append(UUIDUtils.digits(uuid.getMostSignificantBits(), 4));
        sb.append(UUIDUtils.digits(uuid.getLeastSignificantBits() >> 48, 4));
        sb.append(UUIDUtils.digits(uuid.getLeastSignificantBits(), 12));
        String shortUUID = sb.toString();
        char cover = DICTIONARY_62[new Random().nextInt(62)];
        return shortUUID + cover;
    }

    static {
        for (int i = 0; i < DICTIONARY_62.length; ++i) {
            digitMap.put(Character.valueOf(DICTIONARY_62[i]), i);
        }
        MAX_RADIX = DICTIONARY_62.length;
    }
}

