/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.app.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.phoenix.recog.app.config.OSSSettings;
import com.xforceplus.phoenix.recog.app.utils.DateUtils;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UploadUtils {
    private static final Logger log = Logger.getLogger(UploadUtils.class.getName());
    @Autowired
    private OSSSettings ossSettings;
    private String DOWN_LOAD_URL_PRIFIX = "";
    public static final String DEFAULT_URL_ENCODE = "UTF-8";
    private String accessId = "Z2nVA9OmlwdtWaD6";
    private String accessKey = "W4oMLiIn43APTVu6RfpBRtCMubug8a";
    private String ossEndpoint = "http://oss-cn-hangzhou.aliyuncs.com/";
    private String ossEndpointString = "oss-cn-hangzhou.aliyuncs.com/";
    private String schema = "http://";
    private String bucketName = "phoenix-normal";
    private OSSClient client = null;

    @PostConstruct
    public void init() {
        this.accessId = this.ossSettings.getAccessId();
        this.accessKey = this.ossSettings.getAccessKey();
        this.ossEndpoint = this.ossSettings.getOssEndpoint();
        this.bucketName = this.ossSettings.getBucketName();
        this.client = new OSSClient(this.ossEndpoint, this.accessId, this.accessKey);
    }

    public String uploadToCloud(Long userId, InputStream is, String fileExtension) {
        String nowString = DateUtils.getTime17();
        String key = String.format("phoenix/recog/%s/%s.%s", userId, nowString, fileExtension);
        ObjectMetadata meta = new ObjectMetadata();
        PutObjectResult result = this.client.putObject(this.bucketName, key, is, meta);
        return key;
    }

    public String upload(Long userId, InputStream is, String fileExtension) {
        String pathKey = this.uploadToCloud(userId, is, fileExtension);
        String url = this.schema + this.bucketName + "." + this.ossEndpointString + pathKey;
        log.info("fileUrl: " + url);
        return url;
    }
}

