/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.StringUtils;

public class CommonUtils {
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().length() == 0) {
            return true;
        }
        return str.trim().equalsIgnoreCase("null");
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static void copyProperties(Object src, Object dest) {
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
        beanUtilsBean.getConvertUtils().register((Converter)new BigDecimalConverter(null), BigDecimal.class);
        beanUtilsBean.getConvertUtils().register((Converter)new DateConverter(null), java.util.Date.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimestampConverter(null), Timestamp.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlDateConverter(null), Date.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimeConverter(null), Time.class);
        try {
            beanUtilsBean.copyProperties(dest, src);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String getPlainString(String value) {
        BigDecimal bd = new BigDecimal(value);
        return bd.toPlainString();
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static boolean useList(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static String fill(String str, int length) {
        String backStr = str;
        while (backStr.length() < length) {
            backStr = "0" + backStr;
        }
        return backStr;
    }

    public static String fill2(int i) {
        return CommonUtils.fill(i + "", 2);
    }

    public static String fill3(int i) {
        return CommonUtils.fill(i + "", 3);
    }

    public static String fill4(int i) {
        return CommonUtils.fill(i + "", 4);
    }

    public static String fill5(int i) {
        return CommonUtils.fill(i + "", 5);
    }

    public static String fillN(int n) {
        return CommonUtils.fill("0", n);
    }

    public static String getNumber(String str) {
        String result = "";
        Pattern p = Pattern.compile("[0-9]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            result = result + m.group();
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String nullToString(String str) {
        return str == null || str.equals("null") ? "" : str;
    }

    public static String getCharater(String str) {
        String result = "";
        Pattern p = Pattern.compile("([\u4e00-\u9fa5]+)");
        Matcher m = p.matcher(str);
        while (m.find()) {
            result = result + m.group();
        }
        return result;
    }

    public static boolean checkChineseValue(String value) {
        Pattern p = Pattern.compile("^[\u4e00-\u9fa5]+$");
        Matcher m = p.matcher(value);
        boolean b = m.matches();
        return b;
    }

    public static boolean hasChinese(String companyNameKey) {
        boolean flag = false;
        String regEx = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(regEx);
        Matcher matcher = pat.matcher(companyNameKey);
        if (matcher.find()) {
            flag = true;
        }
        return flag;
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(CommonUtils.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    public static String getPassword(String password) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] psd = md.digest(password.getBytes("UTF-8"));
        password = CommonUtils.byteArrayToHexString(psd);
        return password;
    }

    public static String replaceStr(String res, String oldChar, String newChar) {
        if (CommonUtils.isEmpty(res)) {
            return "";
        }
        return res.replace(oldChar, newChar);
    }

    public static int getLastLetterValue(String str) {
        int i;
        int result = -1;
        char[] ch = str.toCharArray();
        char[] chReverse = new char[ch.length];
        for (i = 0; i < ch.length; ++i) {
            chReverse[i] = ch[ch.length - 1 - i];
        }
        for (i = 0; i < chReverse.length; ++i) {
            String chStr = chReverse[i] + "";
            try {
                Integer.parseInt(chStr);
                continue;
            }
            catch (Exception e) {
                result = i;
                return chReverse.length - 1 - result;
            }
        }
        return result;
    }

    public static int realStringLengthGBK(String a) {
        a = a + "";
        int num = 0;
        String b = "";
        try {
            b = new String(a.getBytes("GBK"), "ISO8859_1");
            num = b.length();
        }
        catch (Exception ex) {
            num = a.length();
        }
        return num;
    }

    public static int realStringLengthUTF8(String a) {
        a = a + "";
        int num = 0;
        String b = "";
        try {
            b = new String(a.getBytes("UTF-8"), "ISO8859_1");
            num = b.length();
        }
        catch (Exception ex) {
            num = a.length();
        }
        return num;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String replaceTab(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isLetterDigit(String str) {
        String regex = "^[a-z0-9A-Z0x30-0x39]+$";
        return str.matches(regex);
    }

    public static boolean isAllDigit(String str) {
        String regex = "^[0-90x30-0x39]+$";
        return str.matches(regex);
    }

    public static boolean containSpecial(String s) {
        boolean flag = false;
        if (!s.matches("[A-Za-z0-9]*")) {
            flag = true;
        }
        return flag;
    }

    public static String converToHslf(String str) {
        String strq = str.trim().replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09");
        return strq;
    }

    public static ArrayList splitByParam(String content, int num) {
        ArrayList<String> list = new ArrayList<String>();
        if (CommonUtils.isEmpty(content) || num <= 0) {
            return list;
        }
        int length = content.length();
        int size = length / num;
        for (int i = 0; i < num; ++i) {
            int beginIndex = size * i;
            int endIndex = size * (i + 1);
            String item = i == num - 1 ? content.substring(beginIndex) : content.substring(beginIndex, endIndex);
            item = item.replaceAll(">", "&gt");
            item = item.replaceAll("<", "&lt");
            list.add(item);
        }
        return list;
    }

    public static InputStream httpDownload(String httpUrl) {
        try {
            URL url = new URL(httpUrl);
            InputStream inStream = url.openStream();
            if (inStream.available() < 3000) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1204];
            int read = 0;
            while ((read = inStream.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            byte[] in_b = out.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(in_b);
            return inputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean telPhoneNum(String str) {
        boolean result = false;
        Pattern p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        Matcher m = p.matcher(str);
        while (m.find()) {
            result = true;
        }
        return result;
    }

    public static boolean checkEmail(String str) {
        String regex = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        return str.matches(regex);
    }

    public static String randomPassword(int length) {
        char[] ss = new char[length];
        int[] flag = new int[]{0, 0, 0};
        for (int i = 0; flag[0] == 0 || flag[1] == 0 || flag[2] == 0 || i < length; ++i) {
            int f = (int)(Math.random() * 3.0 % 3.0);
            ss[i %= length] = f == 0 ? (char)(65.0 + Math.random() * 26.0) : (f == 1 ? (char)(97.0 + Math.random() * 26.0) : (char)(50.0 + Math.random() * 8.0));
            flag[f] = 1;
        }
        String aa = new String(ss);
        aa = aa.replace("O", "X");
        aa = aa.replace("o", "x");
        aa = aa.replace("l", "a");
        aa = aa.replace("i", "m");
        aa = aa.replace("Z", "S");
        aa = aa.replace("z", "s");
        return aa;
    }

    public static String randomPassword() {
        return CommonUtils.randomPassword(6);
    }

    public static String randomBigPassword(int length) {
        char[] ss = new char[length];
        int[] flag = new int[]{0, 0};
        for (int i = 0; flag[0] == 0 || flag[1] == 0 || i < length; ++i) {
            int f = (int)(Math.random() * 2.0 % 2.0);
            ss[i %= length] = f == 0 ? (char)(65.0 + Math.random() * 26.0) : (char)(50.0 + Math.random() * 8.0);
            flag[f] = 1;
        }
        String aa = new String(ss);
        aa = aa.replace("O", "X");
        aa = aa.replace("o", "x");
        aa = aa.replace("l", "a");
        aa = aa.replace("i", "m");
        aa = aa.replace("Z", "S");
        aa = aa.replace("z", "s");
        return aa;
    }

    public static String randomSmallPassword(int length) {
        char[] ss = new char[length];
        int[] flag = new int[]{0, 0};
        for (int i = 0; flag[0] == 0 || flag[1] == 0 || i < length; ++i) {
            int f = (int)(Math.random() * 2.0 % 2.0);
            ss[i %= length] = f == 0 ? (char)(97.0 + Math.random() * 26.0) : (char)(50.0 + Math.random() * 8.0);
            flag[f] = 1;
        }
        String aa = new String(ss);
        aa = aa.replace("O", "X");
        aa = aa.replace("o", "x");
        aa = aa.replace("l", "a");
        aa = aa.replace("i", "m");
        aa = aa.replace("Z", "S");
        aa = aa.replace("z", "s");
        return aa;
    }

    public static String randomBigPassword(int n, int m) {
        String aa = "";
        char[] ss = new char[n];
        char[] pp = new char[m];
        int[] flag = new int[]{0, 0};
        for (int i = 0; i < n; ++i) {
            ss[i %= n] = (char)(65.0 + Math.random() * 26.0);
        }
        for (int j = 0; j < m; ++j) {
            pp[j %= m] = (char)(50.0 + Math.random() * 8.0);
        }
        aa = new String(ss) + new String(pp);
        aa = aa.replace("O", "X");
        aa = aa.replace("l", "A");
        aa = aa.replace("Z", "S");
        return aa;
    }

    public static String randomBigletter(int length) {
        char[] ss = new char[length];
        for (int i = 0; i < length; ++i) {
            ss[i %= length] = (char)(65.0 + Math.random() * 26.0);
        }
        String aa = new String(ss);
        return aa;
    }

    public static BigDecimal getTaxRate(BigDecimal taxAmount, BigDecimal amountWithoutTax) {
        if (taxAmount == null || amountWithoutTax == null) {
            return BigDecimal.ZERO;
        }
        if (amountWithoutTax.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxRate = new BigDecimal("0");
        try {
            taxRate = taxAmount.divide(amountWithoutTax, 2, 4).multiply(new BigDecimal(100));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taxRate;
    }

    public static boolean checkTaxNoLength(String companyTaxNo) {
        if (CommonUtils.isEmpty(companyTaxNo)) {
            return false;
        }
        return companyTaxNo.length() == 15 || companyTaxNo.length() == 17 || companyTaxNo.length() == 18 || companyTaxNo.length() == 19 || companyTaxNo.length() == 20;
    }

    public static boolean checkCipherTextLength(String ciperText) {
        if (CommonUtils.isEmpty(ciperText)) {
            return false;
        }
        return ciperText.length() == 84 || ciperText.length() == 108 || ciperText.length() == 112;
    }

    public static String getPaperDrewDateMonth(String paperDrewDate) {
        if (!CommonUtils.isEmpty(paperDrewDate) && paperDrewDate.length() > 6) {
            paperDrewDate = paperDrewDate.substring(0, 6);
        }
        return paperDrewDate;
    }

    public static String codedPassword(String password) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException var4) {
            var4.getStackTrace();
            return null;
        }
        try {
            digest.update(password.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException var3) {
            var3.getStackTrace();
        }
        return CommonUtils.encodeHex(digest.digest());
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final String MD5(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes("utf-8"));
            return CommonUtils.encodeHex(digest.digest());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static String removeLastCharacter(String str) {
        if (!CommonUtils.isEmpty(str)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String defaultIfEmpty(String str, String defaultString) {
        return str == null ? defaultString : (str.trim().length() == 0 ? " " : str);
    }

    public static String getTimeMinus(String str1, String str2) {
        SimpleDateFormat df = null;
        df = str1.length() == 17 ? new SimpleDateFormat("yyyyMMddHHmmssSSS") : new SimpleDateFormat("yyyyMMddHHmmss");
        java.util.Date date1 = null;
        java.util.Date date2 = null;
        try {
            date1 = df.parse(str1);
            date2 = df.parse(str2);
        }
        catch (Exception e1) {
            return " ";
        }
        try {
            long d = date1.getTime() > date2.getTime() ? date1.getTime() - date2.getTime() : date2.getTime() - date1.getTime();
            long dd = d / 1000L;
            long day1 = dd / 86400L;
            long hour1 = dd % 86400L / 3600L;
            long minute1 = dd % 3600L / 60L;
            if (day1 > 0L) {
                return day1 + "\u5929" + hour1 + "\u5c0f\u65f6 " + minute1 + "\u5206\u949f";
            }
            if (hour1 > 0L) {
                return hour1 + "\u5c0f\u65f6 " + minute1 + "\u5206\u949f";
            }
            return minute1 + "\u5206\u949f";
        }
        catch (Exception e) {
            e.printStackTrace();
            return " ";
        }
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String nowString = sdf.format(new java.util.Date());
        return nowString;
    }

    public static List toList(Map map, String id) {
        Iterator iter = map.keySet().iterator();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (id.equalsIgnoreCase(key)) continue;
            HashMap hashMap = new HashMap();
            hashMap.put(id, map.get(id));
            hashMap.put("tableKey", key);
            hashMap.put("tableValue", map.get(key));
            list.add(hashMap);
        }
        return list;
    }

    public static List MapList2List(List list, String key) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof Map)) continue;
            retList.add(((Map)list.get(i)).get(key) + "");
        }
        return retList;
    }

    public static String getInvoiceTypeByMessageType(String type) {
        if (CommonUtils.isEmpty(type)) {
            return "";
        }
        return type.startsWith("Z") ? "s" : "c";
    }

    public static <V> Map<String, V> removeDefaultJmsHeaders(Map<String, V> properties) {
        LinkedHashMap newProperties = Maps.newLinkedHashMap();
        properties.forEach((key, value) -> {
            if (!key.startsWith("jms_") && !key.equals("timestamp")) {
                newProperties.put(key, value);
            }
        });
        return newProperties;
    }

    public static void assertNotEmpty(List list, String messasge) {
        if (list.size() == 0) {
            throw new IllegalArgumentException(messasge);
        }
    }

    public static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570\u5bf9\u8c61\u4e3anull");
        }
    }

    public static String getValueWithDefault(String actualValue, String defaultValue) {
        if (CommonUtils.isEmpty(actualValue)) {
            return defaultValue;
        }
        return actualValue;
    }

    public static BigDecimal getBigDecimal(String amount) {
        try {
            return new BigDecimal(CommonUtils.isEmpty(amount) ? "0" : amount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    public static Integer getInterger(String amount) {
        try {
            return Integer.valueOf(CommonUtils.isEmpty(amount) ? "0" : amount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.valueOf("0");
        }
    }

    public static String[] parseStringToArray(String textMsg) {
        String[] rows = textMsg.trim().split("\n");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rows.length && rows.length > 0; ++i) {
            if (rows[i] == null || "".equals(rows[i].trim().toString())) continue;
            list.add(rows[i]);
        }
        String[] newArray = new String[list.size()];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = (String)list.get(i);
        }
        return newArray;
    }

    public static int compareDate(java.util.Date date1, java.util.Date date2) {
        CommonUtils.assertNotNull(date1);
        CommonUtils.assertNotNull(date2);
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        if (time1 > time2) {
            return 1;
        }
        if (time1 < time2) {
            return -1;
        }
        return 0;
    }

    public static int compareDate(String str_date1, String str_date2, String pattern) {
        Integer result = 0;
        try {
            CommonUtils.assertNotNull(str_date1);
            CommonUtils.assertNotNull(str_date2);
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            java.util.Date date1 = sdf.parse(str_date1);
            java.util.Date date2 = sdf.parse(str_date2);
            long time1 = date1.getTime();
            long time2 = date2.getTime();
            result = time1 > time2 ? Integer.valueOf(1) : (time1 < time2 ? Integer.valueOf(-1) : Integer.valueOf(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String join(Collection<String> list, String spliter) {
        CharSequence[] a = list.toArray(new String[list.size()]);
        return String.join((CharSequence)spliter, a);
    }

    public static String joinUnique(Collection<String> list, String spliter) {
        HashSet<String> set = new HashSet<String>(list);
        CharSequence[] a = set.toArray(new String[set.size()]);
        return String.join((CharSequence)spliter, a);
    }

    public static String splitStringWithLength(String temp, int length) {
        if (CommonUtils.isEmpty(temp)) {
            return "";
        }
        if (length < 0) {
            return "";
        }
        temp = temp.length() > length ? temp.substring(0, length) : temp;
        return temp;
    }

    public static <T> Map bean2Map(T bean) {
        Map map;
        HashMap finalMap = map = Maps.newHashMap();
        map = Optional.ofNullable(bean).map(obj -> {
            BeanMap beanMap = BeanMap.create((Object)obj);
            for (Object key : beanMap.keySet()) {
                finalMap.put(key + "", beanMap.get(key));
            }
            return finalMap;
        }).orElse(map);
        return map;
    }

    public static String encode(String chinese, String charset) {
        chinese = chinese == null ? "" : chinese;
        try {
            return URLEncoder.encode(chinese, charset);
        }
        catch (UnsupportedEncodingException e) {
            return chinese;
        }
    }

    public static String decode(String chinese) {
        return CommonUtils.decode(chinese, "UTF-8");
    }

    public static String decode(String chinese, String charset) {
        chinese = chinese == null ? "" : chinese;
        try {
            return URLDecoder.decode(chinese, charset);
        }
        catch (UnsupportedEncodingException e) {
            return chinese;
        }
    }

    public static String substrText(String str) {
        if (!CommonUtils.isEmpty(str) && str.length() > 50000) {
            str = str.substring(0, 50000);
        }
        return str + "";
    }

    public static String substrTextWithlength(String str, int length) {
        if (!CommonUtils.isEmpty(str) && str.length() > length) {
            str = str.substring(0, length);
        }
        return str + "";
    }

    public static boolean isEdit(Long id) {
        return id != null && id > 0L;
    }

    public static boolean compareThree(BigDecimal val1, BigDecimal val2, BigDecimal val3) {
        if (val1 != null && val2 != null && val3 != null) {
            return val1.compareTo(val2) == 0 && val1.compareTo(val3) == 0;
        }
        if (val1 == null && val2 != null && val3 != null) {
            return val2.compareTo(val3) == 0;
        }
        if (val1 != null && val2 == null && val3 != null) {
            return val1.compareTo(val3) == 0;
        }
        if (val1 != null && val2 != null && val3 == null) {
            return val1.compareTo(val2) == 0;
        }
        if (val1 == null && val2 == null || val2 == null && val3 == null || val1 == null && val3 == null) {
            return false;
        }
        return false;
    }

    public static boolean compareThree(String val1, String val2, String val3) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val2) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val3)) {
            return val1.equals(val2) && val1.equals(val3);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val2) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val3)) {
            return val2.equals(val3);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val2) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val3)) {
            return val1.equals(val3);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val2) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val3)) {
            return val1.equals(val2);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val2) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val2) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val3) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)val3)) {
            return false;
        }
        return false;
    }

    public static String getProvinceCode(String invoiceCode) {
        String dqCode = "";
        dqCode = invoiceCode.length() == 12 ? invoiceCode.substring(1, 5) : invoiceCode.substring(0, 4);
        if (!(dqCode.equals("2102") || dqCode.equals("3302") || dqCode.equals("3502") || dqCode.equals("3702") || dqCode.equals("4403"))) {
            dqCode = dqCode.substring(0, 2) + "00";
        }
        return dqCode;
    }

    public static long parseLong(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return 0L;
        }
        return Long.parseLong(value.toString());
    }

    public static <T> List<List<T>> splitEqually(List<T> list, int partSize) {
        ArrayList<List<T>> totalList = new ArrayList<List<T>>();
        int size = list.size();
        int count = size / partSize + 1;
        int fromIndex = 0;
        int toIndex = 0;
        for (int i = 0; i < count; ++i) {
            int remainSize = size - toIndex;
            toIndex = (remainSize > partSize ? partSize : remainSize) + fromIndex;
            List<T> subList = list.subList(fromIndex, toIndex);
            totalList.add(subList);
            fromIndex = toIndex;
        }
        return totalList;
    }
}

