/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CompareUtils {
    private static final Logger log = LoggerFactory.getLogger(CompareUtils.class);

    private static List<String> findDiffField(Object obj1, Object obj2, String fieldNameString) {
        Field[] field1s;
        ArrayList<String> diffKeys = new ArrayList<String>();
        Class<?> clazz1 = obj1.getClass();
        Class<?> clazz2 = obj2.getClass();
        if (obj1 == null || obj2 == null || !clazz1.equals(clazz2)) {
            return diffKeys;
        }
        for (Field field1 : field1s = clazz1.getClass().getDeclaredFields()) {
            try {
                String fieldName = field1.getName();
                fieldNameString = fieldNameString + "." + fieldName;
                PropertyDescriptor pd1 = new PropertyDescriptor(fieldName, clazz1);
                Method getMethod = pd1.getReadMethod();
                Object o1 = getMethod.invoke(obj1, new Object[0]);
                Object o2 = getMethod.invoke(obj2, new Object[0]);
                if (!CompareUtils.canCompareField(o1)) continue;
                CompareUtils.addDiffField(diffKeys, fieldNameString, o1, o2);
            }
            catch (Exception e) {
                log.error("\u67e5\u627e\u5dee\u5f02\u5c5e\u6027\u9519\u8bef", (Throwable)e);
            }
        }
        return diffKeys;
    }

    public static <T> List<String> findDiffField(List<T> objects, List<String> fieldNames) {
        ArrayList<String> diffKeys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(objects) || objects.size() == 1 || CollectionUtils.isEmpty(fieldNames)) {
            return diffKeys;
        }
        Class<?> clazz0 = objects.get(0).getClass();
        List<Field> compareFields = CompareUtils.getCompareFields(clazz0, fieldNames);
        if (CollectionUtils.isEmpty(compareFields)) {
            return diffKeys;
        }
        return CompareUtils.findDiffField(objects, compareFields, clazz0);
    }

    private static <T> List<String> findDiffField(List<T> objs, List<Field> fields, Class clazz) {
        ArrayList<String> diffKeys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(fields) || null == clazz || CollectionUtils.isEmpty(objs)) {
            return diffKeys;
        }
        for (Field field0 : fields) {
            ArrayList<Object> fieldValues = new ArrayList<Object>();
            String fieldName = field0.getName();
            boolean jumpFlag = false;
            for (T object : objs) {
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(fieldName, clazz);
                    Method getMethod = pd.getReadMethod();
                    Object fieldValue = getMethod.invoke(object, new Object[0]);
                    if (!CompareUtils.canCompareField(fieldValue)) {
                        jumpFlag = true;
                        break;
                    }
                    fieldValues.add(fieldValue);
                }
                catch (Exception e) {
                    log.error("\u67e5\u627e\u5dee\u5f02\u5c5e\u6027\u9519\u8bef", (Throwable)e);
                    jumpFlag = true;
                    break;
                }
            }
            if (jumpFlag || CollectionUtils.isEmpty(fieldValues)) continue;
            CompareUtils.addDiffField(diffKeys, fieldName, fieldValues);
        }
        return diffKeys;
    }

    private static List<Field> getCompareFields(Class clazz, List<String> fieldNames) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (CollectionUtils.isEmpty(fieldNames)) {
            return fields;
        }
        for (String fieldName : fieldNames) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                fields.add(field);
            }
            catch (NoSuchFieldException e) {
                log.warn("\u6ca1\u6709\u8fd9\u6837\u7684fieldName: ", (Object)fieldName, (Object)e);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6field\u9519\u8bef", (Throwable)e);
            }
        }
        return fields;
    }

    private static boolean canCompareField(Object object) {
        return object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Date || object instanceof BigDecimal || object instanceof Float || object instanceof Number || object instanceof Float || object instanceof String || null == object;
    }

    private static String getDiffField(String fieldName, Object object1, Object object2) {
        if (CompareUtils.compareFieldValue(object1, object2)) {
            return null;
        }
        return fieldName;
    }

    private static String getDiffField(String fieldName, List<Object> fieldValues) {
        if (CompareUtils.compareFieldValue(fieldValues)) {
            return null;
        }
        return fieldName;
    }

    private static void addDiffField(List<String> fieldNames, String fieldName, List<Object> fieldValues) {
        if (CompareUtils.getDiffField(fieldName, fieldValues) != null) {
            if (fieldName.startsWith(".")) {
                fieldName = fieldName.substring(1);
            }
            fieldNames.add(fieldName);
        }
    }

    private static void addDiffField(List<String> fieldNames, String fieldName, Object object1, Object object2) {
        if (CompareUtils.getDiffField(fieldName, object1, object2) != null) {
            if (fieldName.startsWith(".")) {
                fieldName = fieldName.substring(1);
            }
            fieldNames.add(fieldName);
        }
    }

    public static boolean compareFieldValue(Object object1, Object object2) {
        if (null == object1 && null != object2) {
            return false;
        }
        if (null != object1 && null == object2) {
            return false;
        }
        if (null == object1 && null == object2) {
            return true;
        }
        if (!object1.getClass().equals(object2.getClass())) {
            return false;
        }
        if (object1 instanceof Date) {
            return ((Date)object1).getTime() == ((Date)object2).getTime();
        }
        return object1.toString().equals(object2.toString());
    }

    private static boolean compareFieldValue(List<Object> fieldValues) {
        if (CollectionUtils.isEmpty(fieldValues) || fieldValues.size() == 1) {
            return true;
        }
        Object fieldValue0 = fieldValues.get(0);
        List<Object> subValues = fieldValues.subList(1, fieldValues.size());
        for (Object subValue : subValues) {
            if (CompareUtils.compareFieldValue(fieldValue0, subValue)) continue;
            return false;
        }
        return true;
    }
}

