/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_TIME19_REGEX = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s(([0-1]{1}\\d{1})|([2]{1}[0-3]))\\:([0-5]{1}\\d{1})\\:([0-5]{1}\\d{1})$";
    public static final String DATE_TIME8_REGEX = "^(?:(?!0000)[0-9]{4}(?:(?:0[1-9]|1[0-2])(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])(?:29|30)|(?:0[13578]|1[02])31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)0229)$";
    public static final String DATE_TIME6_REGEX = "^(?:(?!0000)[0-9]{4}(?:(?:0[1-9]|1[0-2])))$";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATEDETAIL_PATTERN = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String DEFAULT_DATE_FORMAT8_STR = "yyyyMMdd";
    public static final String DEFAULT_DATE_FORMAT6_STR = "yyyyMM";
    public static final String DATE8_PATTERN = "yyyyMMdd";
    public static final String DATE10_PATTERN = "yyyy-MM-dd";
    public static final String TIME6_PATTERN = "HHmmss";
    public static final String TIME8_PATTERN = "HH:mm:ss";
    public static final String DATETIME14_PATTERN = "yyyyMMddHHmmss";
    public static final String DATETIME19_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEMSEL17_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String DATEMSEL18_PATTERN = "yyyyMMddHHmmssSSSS";
    public static final String DATE_FORMAT_FULL = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_SHORT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_COMPACT = "yyyyMMdd";
    public static final String DATE_FORMAT_COMPACTFULL = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_FULL_MSEL = "yyyyMMddHHmmssSSSS";
    public static final String DATE_YEAR_MONTH = "yyyyMM";
    public static final String DATE_FORMAT_FULL_MSE = "yyyyMMddHHmmssSSS";
    public static Date DefaultDate = null;

    private static SimpleDateFormat getDateParser(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Timestamp getTimestap() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date curDate() {
        return new Date();
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static String curDateStr(String strFormat) {
        Date date = new Date();
        return DateUtils.getDateParser(strFormat).format(date);
    }

    public static String getCurDateTime(String format) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = now.format(dateTimeFormatter);
        return dataTime;
    }

    public static String curDateStr() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static Timestamp curTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static Date toDate(String dateString, String pattern) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(pattern).parse(dateString);
            return date;
        }
        catch (Exception var4) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var4);
            return null;
        }
    }

    public static Date toDate(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd").parse(dateString);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").parse(dateString);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static Date toDetailDateTime(String dateString) {
        Date date = null;
        try {
            date = DateUtils.getDateParser(DEFAULT_DATEDETAIL_PATTERN).parse(dateString);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateString + "ex:" + var3);
            return null;
        }
    }

    public static String toDateStr(Date date, String pattern) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser(pattern).format(date);
    }

    public static String toDateStr(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String toDateTimeStr(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String curDateStr8() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyyMMdd").format(date);
    }

    public static String curDateStr10() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String curDateTimeStr14() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyyMMddHHmmss").format(date);
    }

    public static String curDateTimeStr19() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String curDateTimeStr23() {
        Date date = new Date();
        return DateUtils.getDateParser(DEFAULT_DATEDETAIL_PATTERN).format(date);
    }

    public static String curTimeStr6() {
        Date date = new Date();
        return DateUtils.getDateParser(TIME6_PATTERN).format(date);
    }

    public static String curDateMselStr14() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String curDateMselStr17() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyyMMddHHmmssSSS").format(date);
    }

    public static String curDateMselStr18() {
        Date date = new Date();
        return DateUtils.getDateParser("yyyyMMddHHmmssSSSS").format(date);
    }

    public static Date toDate8(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyyMMdd").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDate10(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime14(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyyMMddHHmmss").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static Date toDateTime19(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").parse(dateStr);
            return date;
        }
        catch (Exception var3) {
            logger.warn("\u89e3\u6790date\u5b57\u7b26\u4e32\u65f6\u51fa\u9519,\u8fd4\u56denull. dateString:" + dateStr + "ex:" + var3);
            return null;
        }
    }

    public static String toDateStr8(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyyMMdd").format(date);
    }

    public static String toDateStr10(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd").format(date);
    }

    public static String toDateTimeStr14(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyyMMddHHmmss").format(date);
    }

    public static String toDateTimeStr19(Date date) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
            }
            return "";
        }
        return DateUtils.getDateParser("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date addDays(Date date, int days) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56denull");
            }
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static boolean isDateBetween(Date date, Date date1, Date date2) {
        return !(!date1.before(date) && !date1.equals(date) || !date.before(date2) && !date.equals(date2));
    }

    public static int getDaysInterval(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null) {
            long timeInterval = toDate.getTime() - fromDate.getTime();
            int daysInterval = (int)(timeInterval / 86400000L);
            return daysInterval;
        }
        logger.warn("getDaysInterval\u65f6,\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c0");
        return 0;
    }

    public static int getWeekOfYear(Date date) {
        if (date == null) {
            logger.warn("\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c-1");
            return -1;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int week = calendar.get(3);
        return week;
    }

    public static int getDayOfWeek(Date date) {
        if (date == null) {
            logger.warn("\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c-1");
            return -1;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(7);
        if (0 == --day) {
            day = 7;
        }
        return day;
    }

    public static Date getLastDayInMonth(Date date) {
        return DateUtils.getLastDayInMonth(date, 0);
    }

    public static Date getLastDayInNextMonth(Date date) {
        return DateUtils.getLastDayInMonth(date, 1);
    }

    public static Date getLastDayInMonth(Date date, int i) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56denull");
            }
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(2, i + 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static String toDateTime(long times) {
        long hours = (times /= 1000L) / 3600L;
        long minutes = (times -= hours * 3600L) / 60L;
        String result = hours + "(h) " + minutes + "(m) " + (times -= minutes * 60L) + "(s)";
        return result;
    }

    public static String dateDiff(String startTime, String endTime, String format) throws Exception {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        long diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
        return DateUtils.dateDiff(diff);
    }

    public static String dateDiff(String startTime, String endTime) throws Exception {
        return DateUtils.dateDiff(startTime, endTime, "yyyyMMddHHmmss");
    }

    public static String dateDiff(String startTime) throws Exception {
        return DateUtils.dateDiff(startTime, DateUtils.curDateTimeStr14(), "yyyyMMddHHmmss");
    }

    public static String dateDiff(Date startTime, Date endTime) {
        long diff = endTime.getTime() - startTime.getTime();
        return DateUtils.dateDiff(diff);
    }

    public static String dateDiff(long millisecond) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = millisecond / nd;
        long hour = millisecond % nd / nh;
        long min = millisecond % nd % nh / nm;
        long sec = millisecond % nd % nh % nm / ns;
        String ret = "";
        if (sec > 0L) {
            ret = sec + "\u79d2";
        }
        ret = min + "\u5206" + ret;
        if (hour > 0L) {
            ret = hour + "\u5c0f\u65f6" + ret;
        }
        if (day > 0L) {
            ret = day + "\u5929" + ret;
        }
        return ret;
    }

    public static Timestamp toTimestamp(String recReviseTime) {
        try {
            if (recReviseTime != null && !recReviseTime.trim().equals("")) {
                return new Timestamp(DateUtils.toDateTime(recReviseTime).getTime());
            }
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
        return null;
    }

    public static int compare(String time1, String time2, String format) throws Exception {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        long diff = sd.parse(time1).getTime() - sd.parse(time2).getTime();
        return diff >= 0L ? 1 : (diff == 0L ? 0 : -1);
    }

    public static String getDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getTimeStr14() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getTimeStr12() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getLastMonth() {
        return LocalDate.now().minusMonths(1L).format(DateTimeFormatter.ofPattern("yyyyMM"));
    }

    public static String getNextMonth() {
        return LocalDate.now().plusMonths(1L).format(DateTimeFormatter.ofPattern("yyyyMM"));
    }

    public static String getLastMonthByMonth(String month) {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.minusMonths(1L).format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }

    public static String getNextMonthByMonth(String month) {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.plusMonths(1L).format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }

    public static List<String> getMonthForCurrentYear(String year) {
        ArrayList<String> dateStrs = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date = sdf.parse(year);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMM");
            for (int i = 0; i < 12; ++i) {
                dateStrs.add(dtf.format(localDate.plusMonths(i)));
            }
        }
        catch (ParseException var2) {
            var2.printStackTrace();
        }
        return dateStrs;
    }

    public static String getCurrentDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        String nowString = sdf.format(now);
        return nowString;
    }

    public static String getLastDayByday(int days) {
        return LocalDate.now().minusDays(days).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static String getNextDayByday(String lastDay, int days) {
        lastDay = lastDay.substring(0, 4) + "-" + lastDay.substring(4, 6) + "-" + lastDay.substring(6, 8);
        LocalDate date = LocalDate.parse(lastDay);
        return date.plusDays(days).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static String getLastDay() {
        return LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static Date str8ToFormatStr17(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateStr = dateStr.substring(0, 4) + "-" + dateStr.substring(4, 6) + "-" + dateStr.substring(6, 8) + " 00:00:00.000";
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String toFarmatStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String nowString = sdf.format(date);
        return nowString;
    }

    public static String getCurDateTimeFull() {
        return DateUtils.getCurDateTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurDateTime1() {
        return DateUtils.getCurDateTime("yyyyMMddHHmmss");
    }

    public static String getCurDateYYYYMM() {
        return DateUtils.getCurDateTime("yyyyMM");
    }

    public static String getCurDateYYYYMMDD() {
        return DateUtils.getCurDateTime("yyyyMMdd");
    }

    public static boolean isCurrentDay(String strDate) {
        boolean bRet = false;
        LocalDate strLocalDate = LocalDate.parse(strDate);
        if (LocalDate.now().getYear() == strLocalDate.getYear()) {
            MonthDay monthDay = MonthDay.from(strLocalDate);
            MonthDay today = MonthDay.from(LocalDate.now());
            return monthDay.equals(today);
        }
        return bRet;
    }

    public static String getAfterDateTime(int hour, String format) {
        LocalTime localTime = LocalTime.now().plusHours(hour);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = localTime.format(dateTimeFormatter);
        return dataTime;
    }

    public static String getTimeStamp() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSS");
        return now.format(dateTimeFormatter);
    }

    public static String parseDateToString(Date thedate, String format) {
        if (thedate != null) {
            Instant instant = thedate.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            return localDateTime.format(dateTimeFormatter);
        }
        return null;
    }

    public static String parseDateToString(Date thedate) {
        return DateUtils.parseDateToString(thedate, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseStringToDate(String thedate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dd1 = null;
        try {
            dd1 = sdf.parse(thedate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dd1;
    }

    public static String changeFormatDateString(String format1, String format2, String strDate) {
        if (strDate == null) {
            return "";
        }
        if (strDate.length() >= format1.length() && format1.length() >= format2.length()) {
            return DateUtils.parseDateToString(DateUtils.parseStringToDate(strDate, format1), format2);
        }
        return strDate;
    }

    public static String beforeNDaysDate(String format, int day) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        if (day > 0) {
            return LocalDateTime.now().minusDays(day).format(dateTimeFormatter);
        }
        return null;
    }

    public static String afterNMonthDate(String theDate, int month, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusMonths(month).format(dateTimeFormatter);
    }

    public static String afterNDaysDate(String theDate, Integer nDayNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusDays(nDayNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNHoursDate(String theDate, Integer nHourNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusHours(nHourNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNMinsDate(String theDate, Integer nMinNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusMinutes(nMinNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNSecondsDate(String theDate, Integer nSecNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusSeconds(nSecNum.intValue()).format(dateTimeFormatter);
    }

    public static boolean isBefore(String strdat1, String strdat2, String format) {
        try {
            Date dat1 = DateUtils.parseStringToDate(strdat1, format);
            Date dat2 = DateUtils.parseStringToDate(strdat2, format);
            return dat1.before(dat2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long isBefore_int(String strdat1, String strdat2, String format) {
        long result = 0L;
        try {
            Date dat1 = DateUtils.parseStringToDate(strdat1, format);
            Date dat2 = DateUtils.parseStringToDate(strdat2, format);
            return dat2.getTime() - dat1.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static String changeTime(int sec) {
        String temp = "";
        temp = sec < 60 ? "" + sec + "\u79d2" : (sec < 3600 ? "" + sec / 60 + "\u5206" + sec % 60 + "\u79d2" : "" + sec / 3600 + "\u5c0f\u65f6" + sec % 3600 / 60 + "\u5206" + sec % 60 + "\u79d2");
        return temp;
    }

    public static int getSubDays(String end, String start) {
        LocalDate startDate = LocalDate.parse(start);
        LocalDate endDate = LocalDate.parse(end);
        Long between = ChronoUnit.DAYS.between(startDate, endDate);
        return between.intValue();
    }

    public static String getTimeDiff(Date time1, Date time2) throws Exception {
        long s;
        long min;
        long hour;
        long l = time1.getTime() - time2.getTime();
        String returnStr = "";
        long day = l / 86400000L;
        if (day > 0L) {
            returnStr = returnStr + day + "\u5929";
        }
        if ((hour = l / 3600000L - day * 24L) > 0L) {
            returnStr = returnStr + hour + "\u5c0f\u65f6";
        }
        if ((min = l / 60000L - day * 24L * 60L - hour * 60L) > 0L) {
            returnStr = returnStr + min + "\u5206";
        }
        if ((s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L) > 0L) {
            returnStr = returnStr + s + "\u79d2";
        }
        return returnStr;
    }

    public static boolean checkYearMonthDay(String ymd) {
        if (ymd == null || ymd.length() == 0) {
            return false;
        }
        String s = ymd.replaceAll("[/\\- ]", "");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = format.parse(s);
            if (!format.format(date).equals(s)) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static Date addDate(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static Date getDayStart(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getToDayStart() {
        return DateUtils.getDayStart(new Date());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static String localDateFomartStr(LocalDate date, String fomart) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(fomart);
        String localTime = df.format(date);
        return localTime;
    }

    public static LocalDate localDateFomartDate(String date, String fomart) {
        if (date == null) {
            return LocalDate.now();
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(fomart);
        LocalDate localTime = LocalDate.parse(date, df);
        return localTime;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206");
        String temp = format.format(date);
        return temp;
    }
}

