/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class ExcelUtils {
    public static final Integer ALIGN_CENTER = 1;
    public static final Integer ALIGN_RIGHT = 2;

    public static SXSSFWorkbook createSXSSFWorkbook(String sheetName, List<String> titles, List<Integer> alignList, List<String[]> contents, SXSSFWorkbook workbook) {
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        Sheet sheet = workbook.createSheet(sheetName);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(false);
        Font normalFont = workbook.createFont();
        normalFont.setFontName("Arial");
        normalFont.setFontHeightInPoints((short)12);
        normalFont.setBoldweight((short)400);
        Font boldFont = workbook.createFont();
        boldFont.setFontName("Arial");
        boldFont.setFontHeightInPoints((short)10);
        boldFont.setBoldweight((short)700);
        boldFont.setColor((short)20);
        CellStyle hcs_center = workbook.createCellStyle();
        hcs_center.setAlignment((short)2);
        hcs_center.setVerticalAlignment((short)1);
        hcs_center.setWrapText(false);
        hcs_center.setFillForegroundColor((short)40);
        hcs_center.setFillPattern((short)1);
        hcs_center.setBorderBottom((short)1);
        hcs_center.setBorderLeft((short)1);
        hcs_center.setBorderRight((short)1);
        hcs_center.setBorderTop((short)1);
        CellStyle ctt_center = workbook.createCellStyle();
        ctt_center.setAlignment((short)2);
        ctt_center.setVerticalAlignment((short)1);
        ctt_center.setWrapText(false);
        ctt_center.setFillForegroundColor((short)43);
        ctt_center.setFillPattern((short)1);
        ctt_center.setBorderBottom((short)1);
        ctt_center.setBorderLeft((short)1);
        ctt_center.setBorderRight((short)1);
        ctt_center.setBorderTop((short)1);
        CellStyle ctt_right = workbook.createCellStyle();
        ctt_right.setAlignment((short)3);
        ctt_right.setVerticalAlignment((short)1);
        ctt_right.setWrapText(false);
        ctt_right.setFillForegroundColor((short)43);
        ctt_right.setFillPattern((short)1);
        ctt_right.setBorderBottom((short)1);
        ctt_right.setBorderLeft((short)1);
        ctt_right.setBorderRight((short)1);
        ctt_right.setBorderTop((short)1);
        Row row = sheet.createRow(0);
        Cell cell = null;
        int titleLen = titles.size();
        HashMap<Integer, CellStyle> alignMap = new HashMap<Integer, CellStyle>(titleLen);
        for (int i = 0; i < titleLen; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(titles.get(i));
            cell.setCellStyle(hcs_center);
            try {
                sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 2 * 256);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (CollectionUtils.isEmpty(alignList) || alignList.size() <= i) {
                alignMap.put(i, ctt_center);
                continue;
            }
            if (ALIGN_RIGHT == alignList.get(i)) {
                alignMap.put(i, ctt_right);
                continue;
            }
            alignMap.put(i, ctt_center);
        }
        int contentLen = contents.size();
        String[] rowContent = null;
        String content = "";
        for (int i = 0; i < contentLen; ++i) {
            row = sheet.createRow(i + 1);
            rowContent = contents.get(i);
            for (int j = 0; j < titleLen; ++j) {
                if (j < rowContent.length) {
                    content = rowContent[j];
                }
                cell = row.createCell(j);
                cell.setCellStyle((CellStyle)alignMap.get(j));
                cell.setCellValue(content);
            }
        }
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFWorkbook(String sheetName, List<String> titles, List<String[]> contents, SXSSFWorkbook workbook) {
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        Sheet sheet = workbook.createSheet(sheetName);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(false);
        Font normalFont = workbook.createFont();
        normalFont.setFontName("Arial");
        normalFont.setFontHeightInPoints((short)12);
        normalFont.setBoldweight((short)400);
        Font boldFont = workbook.createFont();
        boldFont.setFontName("Arial");
        boldFont.setFontHeightInPoints((short)10);
        boldFont.setBoldweight((short)700);
        boldFont.setColor((short)20);
        CellStyle hcs_center = workbook.createCellStyle();
        hcs_center.setAlignment((short)2);
        hcs_center.setVerticalAlignment((short)1);
        hcs_center.setWrapText(false);
        hcs_center.setFillForegroundColor((short)40);
        hcs_center.setFillPattern((short)1);
        hcs_center.setBorderBottom((short)1);
        hcs_center.setBorderLeft((short)1);
        hcs_center.setBorderRight((short)1);
        hcs_center.setBorderTop((short)1);
        CellStyle hcs_left = workbook.createCellStyle();
        hcs_left.setAlignment((short)2);
        hcs_left.setVerticalAlignment((short)1);
        hcs_left.setWrapText(false);
        hcs_left.setFillForegroundColor((short)43);
        hcs_left.setFillPattern((short)1);
        hcs_left.setBorderBottom((short)1);
        hcs_left.setBorderLeft((short)1);
        hcs_left.setBorderRight((short)1);
        hcs_left.setBorderTop((short)1);
        Row row = sheet.createRow(0);
        Cell cell = null;
        int titleLen = titles.size();
        for (int i = 0; i < titleLen; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(titles.get(i));
            cell.setCellStyle(hcs_center);
            try {
                sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 2 * 256);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        int contentLen = contents.size();
        String[] rowContent = null;
        String content = "";
        for (int i = 0; i < contentLen; ++i) {
            row = sheet.createRow(i + 1);
            rowContent = contents.get(i);
            for (int j = 0; j < titleLen; ++j) {
                if (j < rowContent.length) {
                    content = rowContent[j];
                }
                cell = row.createCell(j);
                cell.setCellStyle(hcs_left);
                cell.setCellValue(content);
            }
        }
        return workbook;
    }
}

