/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.DateUtils;
import com.xforceplus.purchaser.common.utils.ExcelMetaRepo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FileTools {
    private static final Logger logger = LoggerFactory.getLogger(FileTools.class);

    public static boolean downloadFile(String fileUrl, String localPath) {
        boolean retval = false;
        int bytesum = 0;
        int byteread = 0;
        try {
            URL url = new URL(fileUrl);
            URLConnection conn = url.openConnection();
            InputStream inStream = conn.getInputStream();
            FileOutputStream fs = new FileOutputStream(localPath);
            byte[] buffer = new byte[1204];
            while ((byteread = inStream.read(buffer)) != -1) {
                System.out.println(bytesum += byteread);
                fs.write(buffer, 0, byteread);
            }
            retval = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public static InputStream getInputStreamByUrl(String downloadUrl) throws FileNotFoundException, IOException {
        URL reqUrl = new URL(downloadUrl);
        HttpURLConnection conn = (HttpURLConnection)reqUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(60000);
        return conn.getInputStream();
    }

    public static String getExtension(String fileName) {
        String[] fileArray = fileName.split("\\.");
        String extension = ".";
        if (fileArray.length > 1) {
            extension = extension + fileArray[fileArray.length - 1];
        }
        return extension;
    }

    public Sheet getSheet(File file, String sheetName) {
        Workbook wb = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u672a\u83b7\u5f97\u4f20\u5165\u7684\u6587\u4ef6,\u8bf7\u5237\u65b0\u9875\u9762,\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u4e0a\u4f20.");
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u4e0d\u662f\u6709\u6548\u7684Excel\u6587\u4ef6,\u8bf7\u5237\u65b0\u9875\u9762,\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u4e0a\u4f20.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u67e5\u9605\u62a5\u9519\u65e5\u5fd7.");
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new RuntimeException("\u63d0\u793a:\u5904\u7406\u5931\u8d25,\u6587\u4ef6\u4e2d\u672a\u627e\u5230[" + sheetName + "]sheet\u9875.");
        }
        return sheet;
    }

    public String getCellValue(Cell cell) {
        String ret = "";
        try {
            if (cell != null) {
                switch (cell.getCellType()) {
                    case 4: {
                        ret = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            double d = cell.getNumericCellValue();
                            Date date = DateUtil.getJavaDate((double)d);
                            ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                            break;
                        }
                        Long temp = Math.round(cell.getNumericCellValue());
                        if (Double.parseDouble(temp + ".0") == cell.getNumericCellValue()) {
                            ret = temp + "";
                            break;
                        }
                        ret = CommonUtils.getPlainString(String.valueOf(cell.getNumericCellValue()));
                        break;
                    }
                    case 1: {
                        ret = cell.getStringCellValue().trim();
                        break;
                    }
                    case 2: {
                        try {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                ret = new SimpleDateFormat("yyyy-MM-dd").format(cell.getDateCellValue());
                                break;
                            }
                            ret = this.parseFormula(cell);
                        }
                        catch (Exception e) {
                            ret = String.valueOf(cell.getRichStringCellValue());
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e2d\u5b58\u5728\u5355\u5143\u683c\u683c\u5f0f\u4e0d\u6b63\u786e\u7b49\u95ee\u9898,\u6570\u636e\u6709\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e2d\u516c\u5f0f\u7b49\u662f\u5426\u5b58\u5728\u5f15\u7528\u5931\u6548\u7b49\u95ee\u9898");
        }
        return ret;
    }

    public String parseFormula(Cell cell) {
        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        String ret = "";
        switch (cellValue.getCellType()) {
            case 4: {
                ret = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    double d = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)d);
                    ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                Long temp = Math.round(cell.getNumericCellValue());
                if (Double.parseDouble(temp + ".0") == cell.getNumericCellValue()) {
                    ret = temp + "";
                    break;
                }
                ret = CommonUtils.getPlainString(String.valueOf(cell.getNumericCellValue()));
                break;
            }
            case 1: {
                ret = cell.getStringCellValue().trim();
            }
        }
        return ret;
    }

    public Object getFieldValue(Field field, Cell cell) {
        if (BigDecimal.class.isAssignableFrom(field.getType())) {
            if (cell.getCellType() == 1) {
                return BigDecimal.valueOf(Double.parseDouble(cell.getStringCellValue()));
            }
            return BigDecimal.valueOf(cell.getNumericCellValue());
        }
        if (Boolean.class.isAssignableFrom(field.getType())) {
            return cell.getBooleanCellValue();
        }
        if (Integer.class.isAssignableFrom(field.getType())) {
            Long temp = Math.round(cell.getNumericCellValue());
            return temp.intValue();
        }
        if (Double.class.isAssignableFrom(field.getType())) {
            return cell.getNumericCellValue();
        }
        return this.getCellValue(cell);
    }

    public boolean createFile(String destFileName) {
        File file = new File(destFileName);
        if (file.exists()) {
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff01");
            return false;
        }
        if (destFileName.endsWith(File.separator)) {
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u76ee\u5f55\uff01");
            return false;
        }
        if (!file.getParentFile().exists()) {
            System.out.println("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa\u5b83\uff01");
            if (!file.getParentFile().mkdirs()) {
                System.out.println("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
                return false;
            }
        }
        try {
            if (file.createNewFile()) {
                System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff01");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff01" + e.getMessage());
            return false;
        }
    }

    public <T> List<T> importExcel(File file, String sheetName, String metaName, Class<T> clazz, Integer limitNums) {
        Sheet sheet = this.getSheet(file, sheetName);
        return this.readExcelData(sheet, metaName, clazz, limitNums);
    }

    public <T> List<T> readExcelData(Sheet sheet, String metaName, Class<T> clazz, Integer limitNums) {
        Map<String, String> metaMap = ExcelMetaRepo.getMetaMap(metaName);
        ArrayList result = Lists.newArrayList();
        Row firstRow = sheet.getRow(0);
        ArrayList sheetColumnNameList = Lists.newArrayList();
        for (Cell cell : firstRow) {
            sheetColumnNameList.add(this.getCellValue(cell));
        }
        String[] sortedTableColumnNameList = new String[sheetColumnNameList.size()];
        int count = 0;
        for (String sheetColumnName : sheetColumnNameList) {
            for (String key : metaMap.keySet()) {
                if (!sheetColumnName.equals(metaMap.get(key))) continue;
                sortedTableColumnNameList[count] = key;
            }
            ++count;
        }
        int rowNo = 1;
        int colNo = 1;
        for (Row row : sheet) {
            if (rowNo == 1) {
                ++rowNo;
                continue;
            }
            if (CommonUtils.isEmpty(this.getCellValue(row.getCell(0))) && CommonUtils.isEmpty(this.getCellValue(row.getCell(1)))) break;
            if (Map.class.isAssignableFrom(clazz)) {
                logger.info("--------------Excel\u89e3\u6790\u751f\u6210Map\u5bf9\u8c61-------------");
                HashMap map = Maps.newHashMap();
                for (Cell cell : row) {
                    String cellValue = this.getCellValue(cell);
                    String cellName = sortedTableColumnNameList[cell.getColumnIndex()];
                    if (StringUtils.isEmpty((Object)cellName)) continue;
                    map.put(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, cellName), cellValue);
                }
                result.add(map);
            } else {
                try {
                    T obj = clazz.newInstance();
                    for (Cell cell : row) {
                        if (sortedTableColumnNameList.length - 1 < cell.getColumnIndex()) continue;
                        String cellName = sortedTableColumnNameList[cell.getColumnIndex()];
                        if (!StringUtils.isEmpty((Object)cellName)) {
                            try {
                                Field field = clazz.getDeclaredField(cellName);
                                field.setAccessible(true);
                                field.set(obj, this.getFieldValue(field, cell));
                            }
                            catch (NoSuchFieldException e) {
                                e.printStackTrace();
                                throw new RuntimeException("\u63d0\u793a\uff1a\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5" + cellName);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("\u63d0\u793a\uff1a\u83b7\u53d6\u4f20\u5165\u5bf9\u8c61\u7c7b\u578b\u7684\u5c5e\u6027\u5931\u8d25.");
                            }
                        }
                        ++colNo;
                    }
                    result.add(obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u63d0\u793a\uff1a\u4f20\u5165\u7684\u5bf9\u8c61\u7c7b\u578b\u5b9e\u4f8b\u5316\u5931\u8d25.[" + e.getMessage() + "]");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u7b2c" + rowNo + "\u884c\u7b2c" + colNo + "\u5217,\u83b7\u53d6\u4f20\u5165\u5bf9\u8c61\u7c7b\u578b\u7684\u5c5e\u6027\u5931\u8d25.[" + e.getMessage() + "]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u7b2c" + rowNo + "\u884c\u7b2c" + colNo + "\u5217,\u89e3\u6790\u6570\u636e\u5931\u8d25.[" + e.getMessage() + "]");
                }
            }
            if (null == limitNums || ++rowNo < limitNums + 3) continue;
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25,\u5355\u6b21\u4e0a\u4f20\u4e0a\u9650\u4e3a" + limitNums + "\u6761,\u60a8\u5df2\u8d85\u9650");
        }
        return result;
    }

    public <T> String exportExcelToOSS(String title, String[] headers, Collection<T> dataset, String pattern, String filename, String keyStr) {
        Workbook workbook = this.createWorkbook(title, headers, dataset, pattern);
        return this.putFile(workbook, pattern, filename, keyStr);
    }

    public <T> Workbook createWorkbook(String title, String[] headers, Collection<T> dataset, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        this.createSheet(workbook, title, headers, dataset, pattern);
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createSheet(HSSFWorkbook workbook, String title, String[] headers, Collection<T> dataset, String pattern) {
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth((short)15);
        sheet.setForceFormulaRecalculation(true);
        HSSFCellStyle styleHeader = workbook.createCellStyle();
        styleHeader.setFillForegroundColor((short)40);
        styleHeader.setFillPattern((short)1);
        styleHeader.setBorderBottom((short)1);
        styleHeader.setBorderLeft((short)1);
        styleHeader.setBorderRight((short)1);
        styleHeader.setBorderTop((short)1);
        styleHeader.setAlignment((short)2);
        HSSFFont fontHeader = workbook.createFont();
        fontHeader.setColor((short)20);
        fontHeader.setFontHeightInPoints((short)12);
        fontHeader.setBoldweight((short)700);
        styleHeader.setFont(fontHeader);
        HSSFCellStyle styleHeaderGrey = workbook.createCellStyle();
        styleHeaderGrey.setFillForegroundColor((short)22);
        styleHeaderGrey.setFillPattern((short)1);
        styleHeaderGrey.setBorderBottom((short)1);
        styleHeaderGrey.setBorderLeft((short)1);
        styleHeaderGrey.setBorderRight((short)1);
        styleHeaderGrey.setBorderTop((short)1);
        styleHeaderGrey.setAlignment((short)2);
        styleHeaderGrey.setFont(fontHeader);
        HSSFCellStyle styleContent = workbook.createCellStyle();
        styleContent.setFillForegroundColor((short)43);
        styleContent.setFillPattern((short)1);
        styleContent.setBorderBottom((short)1);
        styleContent.setBorderLeft((short)1);
        styleContent.setBorderRight((short)1);
        styleContent.setBorderTop((short)1);
        styleContent.setAlignment((short)2);
        styleContent.setVerticalAlignment((short)1);
        HSSFFont fontContent = workbook.createFont();
        fontContent.setBoldweight((short)400);
        styleContent.setFont(fontContent);
        HSSFCellStyle amountStyleContent = workbook.createCellStyle();
        amountStyleContent.setFillForegroundColor((short)43);
        amountStyleContent.setFillPattern((short)1);
        amountStyleContent.setBorderBottom((short)1);
        amountStyleContent.setBorderLeft((short)1);
        amountStyleContent.setBorderRight((short)1);
        amountStyleContent.setBorderTop((short)1);
        amountStyleContent.setAlignment((short)3);
        amountStyleContent.setVerticalAlignment((short)1);
        amountStyleContent.setFont(fontContent);
        HSSFDataFormat format = workbook.createDataFormat();
        amountStyleContent.setDataFormat(format.getFormat("0.00"));
        HSSFCellStyle rateStyleContent = workbook.createCellStyle();
        rateStyleContent.setFillForegroundColor((short)43);
        rateStyleContent.setFillPattern((short)1);
        rateStyleContent.setBorderBottom((short)1);
        rateStyleContent.setBorderLeft((short)1);
        rateStyleContent.setBorderRight((short)1);
        rateStyleContent.setBorderTop((short)1);
        rateStyleContent.setAlignment((short)3);
        rateStyleContent.setVerticalAlignment((short)1);
        rateStyleContent.setFont(fontContent);
        rateStyleContent.setDataFormat(format.getFormat("0.00"));
        HSSFCellStyle dateStyleContent = workbook.createCellStyle();
        dateStyleContent.setFillForegroundColor((short)43);
        dateStyleContent.setFillPattern((short)1);
        dateStyleContent.setBorderBottom((short)1);
        dateStyleContent.setBorderLeft((short)1);
        dateStyleContent.setBorderRight((short)1);
        dateStyleContent.setBorderTop((short)1);
        dateStyleContent.setAlignment((short)2);
        dateStyleContent.setVerticalAlignment((short)1);
        dateStyleContent.setFont(fontContent);
        dateStyleContent.setDataFormat(format.getFormat("yyyy-MM-dd"));
        HSSFCellStyle longDateStyleContent = workbook.createCellStyle();
        longDateStyleContent.setFillForegroundColor((short)43);
        longDateStyleContent.setFillPattern((short)1);
        longDateStyleContent.setBorderBottom((short)1);
        longDateStyleContent.setBorderLeft((short)1);
        longDateStyleContent.setBorderRight((short)1);
        longDateStyleContent.setBorderTop((short)1);
        longDateStyleContent.setAlignment((short)2);
        longDateStyleContent.setVerticalAlignment((short)1);
        longDateStyleContent.setFont(fontContent);
        longDateStyleContent.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        HSSFCellStyle style3 = workbook.createCellStyle();
        style3.setFillForegroundColor((short)43);
        style3.setFillPattern((short)1);
        style3.setBorderBottom((short)1);
        style3.setBorderLeft((short)1);
        style3.setBorderRight((short)1);
        style3.setBorderTop((short)1);
        style3.setAlignment((short)3);
        style3.setVerticalAlignment((short)1);
        style3.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0.00"));
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        style2.setFont(font2);
        style3.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(styleHeader);
            String header = headers[i];
            if (header.equals("\u4ed8\u6b3e\u5355\u53f7") || header.equals("\u5907\u6ce8") || header.equals("\u4ed8\u6b3e\u4eba\u59d3\u540d") || header.equals("\u4ed8\u6b3e\u65f6\u95f4") || header.equals("\u4ed8\u6b3e\u91d1\u989d") || header.equals("\u4ed8\u6b3e\u65b9\u5f0f")) {
                HSSFComment comment;
                cell.setCellStyle(styleHeaderGrey);
                if (header.equals("\u4ed8\u6b3e\u65f6\u95f4")) {
                    comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
                    comment.setString((RichTextString)new HSSFRichTextString("\u65f6\u95f4\u683c\u5f0f\uff1ayyyy-MM-dd\u3002\u793a\u4f8b\uff1a2015-01-01\u3002"));
                    cell.setCellComment((Comment)comment);
                }
                if (header.equals("\u4ed8\u6b3e\u65b9\u5f0f")) {
                    comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
                    comment.setString((RichTextString)new HSSFRichTextString("\u8bf4\u660e\uff1a1-\u73b0\u91d1\uff1b2-\u8f6c\u8d26\uff1b"));
                    cell.setCellComment((Comment)comment);
                }
            }
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            try {
                sheet.setColumnWidth((int)i, header.getBytes("utf-8").length * 2 * 256);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (!header.equals("\u7a0e\u989d")) continue;
            sheet.setColumnWidth((int)i, 5000);
        }
        HSSFFont font3 = workbook.createFont();
        font3.setColor((short)12);
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            logger.info("createSheet row :" + index);
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (short s = 0; s < fields.length; s = (short)(s + 1)) {
                if (s >= headers.length) continue;
                HSSFCell cell = row.createCell(s);
                cell.setCellStyle(style2);
                Field field = fields[s];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    String values;
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    if (value == null || CommonUtils.isEmpty(value.toString())) {
                        value = "\u2014";
                    }
                    if ((values = value.toString()).equals("0")) {
                        values = "0.00";
                    }
                    String textValue = null;
                    textValue = values;
                    if (this.isNum(values)) {
                        int hehe = values.indexOf(".");
                        if (hehe > 0) {
                            cell.setCellStyle(style3);
                            cell.setCellValue(this.pasdouble(textValue));
                        } else {
                            HSSFRichTextString richString = new HSSFRichTextString(textValue);
                            cell.setCellValue((RichTextString)richString);
                        }
                    } else {
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        cell.setCellValue((RichTextString)richString);
                    }
                    cell.setCellStyle(styleContent);
                    if (fieldName.equals("payTime")) {
                        cell.setCellStyle(dateStyleContent);
                    }
                    if (fieldName.equals("amountWithoutTax") || fieldName.equals("taxAmount") || fieldName.equals("amountWithTax") || fieldName.equals("totalPayAmount")) {
                        cell.setCellStyle(amountStyleContent);
                    }
                    if (fieldName.equals("taxRate")) {
                        cell.setCellStyle(rateStyleContent);
                    }
                    sheet.setForceFormulaRecalculation(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        logger.info("\u6587\u4ef6\u751f\u6210\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String pattern, String filename, String keyStr) {
        String filePath = keyStr + filename + ".xls";
        OutputStream out = null;
        File file = null;
        if (!CommonUtils.isEmpty(pattern)) {
            filePath = pattern;
            filename = pattern.substring(pattern.lastIndexOf("/") + 1, pattern.indexOf("."));
        }
        try {
            file = new File(filename + ".xls");
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            workbook.write(out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u6587\u4ef6");
        }
        catch (IOException e) {
            filePath = "";
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile01(Workbook workbook, String pattern, String filename) {
        String filePath = "tmp/" + DateUtils.getDay() + "/export_files/" + filename + ".xls";
        OutputStream out = null;
        File file = null;
        if (!CommonUtils.isEmpty(pattern)) {
            filePath = pattern;
            filename = pattern.substring(pattern.lastIndexOf("/") + 1, pattern.indexOf("."));
        }
        try {
            file = new File(filename + ".xls");
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            workbook.write(out);
        }
        catch (FileNotFoundException e) {
            filePath = "";
            throw new RuntimeException("\u627e\u4e0d\u5230\u6587\u4ef6");
        }
        catch (IOException e) {
            filePath = "";
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return filePath;
    }

    public void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean isNum(String str) {
        return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public double pasdouble(String text) {
        BigDecimal bigDecimal = new BigDecimal(text);
        return bigDecimal.doubleValue();
    }

    public String exportExcelMapToOSS(String title, String[] headers, List<Map> dataset, String filename, String pattern, String keyStr) {
        Workbook workbook = this.createWorkbookMap(title, headers, dataset);
        return this.putFile(workbook, pattern, filename, keyStr);
    }

    public Workbook createWorkbookMap(String title, String[] headers, List<Map> dataset) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        this.createSheetMap(workbook, title, headers, dataset);
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSheetMap01(HSSFWorkbook workbook, String title, String[] headers, List<Map> dataset, String pattern) {
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth((short)15);
        sheet.setForceFormulaRecalculation(true);
        HSSFCellStyle styleHeader = workbook.createCellStyle();
        styleHeader.setFillForegroundColor((short)40);
        styleHeader.setFillPattern((short)1);
        styleHeader.setBorderBottom((short)1);
        styleHeader.setBorderLeft((short)1);
        styleHeader.setBorderRight((short)1);
        styleHeader.setBorderTop((short)1);
        styleHeader.setAlignment((short)2);
        HSSFFont fontHeader = workbook.createFont();
        fontHeader.setColor((short)20);
        fontHeader.setFontHeightInPoints((short)12);
        fontHeader.setBoldweight((short)700);
        styleHeader.setFont(fontHeader);
        HSSFCellStyle styleHeaderGrey = workbook.createCellStyle();
        styleHeaderGrey.setFillForegroundColor((short)22);
        styleHeaderGrey.setFillPattern((short)1);
        styleHeaderGrey.setBorderBottom((short)1);
        styleHeaderGrey.setBorderLeft((short)1);
        styleHeaderGrey.setBorderRight((short)1);
        styleHeaderGrey.setBorderTop((short)1);
        styleHeaderGrey.setAlignment((short)2);
        styleHeaderGrey.setFont(fontHeader);
        HSSFCellStyle styleContent = workbook.createCellStyle();
        styleContent.setFillForegroundColor((short)43);
        styleContent.setFillPattern((short)1);
        styleContent.setBorderBottom((short)1);
        styleContent.setBorderLeft((short)1);
        styleContent.setBorderRight((short)1);
        styleContent.setBorderTop((short)1);
        styleContent.setAlignment((short)2);
        styleContent.setVerticalAlignment((short)1);
        HSSFFont fontContent = workbook.createFont();
        fontContent.setBoldweight((short)400);
        styleContent.setFont(fontContent);
        HSSFCellStyle amountStyleContent = workbook.createCellStyle();
        amountStyleContent.setFillForegroundColor((short)43);
        amountStyleContent.setFillPattern((short)1);
        amountStyleContent.setBorderBottom((short)1);
        amountStyleContent.setBorderLeft((short)1);
        amountStyleContent.setBorderRight((short)1);
        amountStyleContent.setBorderTop((short)1);
        amountStyleContent.setAlignment((short)3);
        amountStyleContent.setVerticalAlignment((short)1);
        amountStyleContent.setFont(fontContent);
        HSSFDataFormat format = workbook.createDataFormat();
        amountStyleContent.setDataFormat(format.getFormat("0.00"));
        HSSFCellStyle rateStyleContent = workbook.createCellStyle();
        rateStyleContent.setFillForegroundColor((short)43);
        rateStyleContent.setFillPattern((short)1);
        rateStyleContent.setBorderBottom((short)1);
        rateStyleContent.setBorderLeft((short)1);
        rateStyleContent.setBorderRight((short)1);
        rateStyleContent.setBorderTop((short)1);
        rateStyleContent.setAlignment((short)3);
        rateStyleContent.setVerticalAlignment((short)1);
        rateStyleContent.setFont(fontContent);
        rateStyleContent.setDataFormat(format.getFormat("0.00"));
        HSSFCellStyle dateStyleContent = workbook.createCellStyle();
        dateStyleContent.setFillForegroundColor((short)43);
        dateStyleContent.setFillPattern((short)1);
        dateStyleContent.setBorderBottom((short)1);
        dateStyleContent.setBorderLeft((short)1);
        dateStyleContent.setBorderRight((short)1);
        dateStyleContent.setBorderTop((short)1);
        dateStyleContent.setAlignment((short)2);
        dateStyleContent.setVerticalAlignment((short)1);
        dateStyleContent.setFont(fontContent);
        dateStyleContent.setDataFormat(format.getFormat("yyyy-MM-dd"));
        HSSFCellStyle longDateStyleContent = workbook.createCellStyle();
        longDateStyleContent.setFillForegroundColor((short)43);
        longDateStyleContent.setFillPattern((short)1);
        longDateStyleContent.setBorderBottom((short)1);
        longDateStyleContent.setBorderLeft((short)1);
        longDateStyleContent.setBorderRight((short)1);
        longDateStyleContent.setBorderTop((short)1);
        longDateStyleContent.setAlignment((short)2);
        longDateStyleContent.setVerticalAlignment((short)1);
        longDateStyleContent.setFont(fontContent);
        longDateStyleContent.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        HSSFCellStyle style3 = workbook.createCellStyle();
        style3.setFillForegroundColor((short)43);
        style3.setFillPattern((short)1);
        style3.setBorderBottom((short)1);
        style3.setBorderLeft((short)1);
        style3.setBorderRight((short)1);
        style3.setBorderTop((short)1);
        style3.setAlignment((short)3);
        style3.setVerticalAlignment((short)1);
        style3.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0.00"));
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        style2.setFont(font2);
        style3.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(styleHeader);
            String header = headers[i];
            if (header.equals("\u4ed8\u6b3e\u5355\u53f7") || header.equals("\u5907\u6ce8") || header.equals("\u4ed8\u6b3e\u4eba\u59d3\u540d") || header.equals("\u4ed8\u6b3e\u65f6\u95f4") || header.equals("\u4ed8\u6b3e\u91d1\u989d") || header.equals("\u4ed8\u6b3e\u65b9\u5f0f")) {
                HSSFComment comment;
                cell.setCellStyle(styleHeaderGrey);
                if (header.equals("\u4ed8\u6b3e\u65f6\u95f4")) {
                    comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
                    comment.setString((RichTextString)new HSSFRichTextString("\u65f6\u95f4\u683c\u5f0f\uff1ayyyy-MM-dd\u3002\u793a\u4f8b\uff1a2015-01-01\u3002"));
                    cell.setCellComment((Comment)comment);
                }
                if (header.equals("\u4ed8\u6b3e\u65b9\u5f0f")) {
                    comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
                    comment.setString((RichTextString)new HSSFRichTextString("\u8bf4\u660e\uff1a1-\u73b0\u91d1\uff1b2-\u8f6c\u8d26\uff1b"));
                    cell.setCellComment((Comment)comment);
                }
            }
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            try {
                sheet.setColumnWidth((int)i, header.getBytes("utf-8").length * 2 * 256);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (!header.equals("\u7a0e\u989d")) continue;
            sheet.setColumnWidth((int)i, 5000);
        }
        HSSFFont font3 = workbook.createFont();
        font3.setColor((short)12);
        Iterator<Map> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            logger.info("createSheet row :" + index);
            row = sheet.createRow(++index);
            Map t = it.next();
            int count = 0;
            for (Object key : t.keySet()) {
                HSSFCell cell = row.createCell(count);
                cell.setCellStyle(style2);
                try {
                    String values;
                    Object fieldName = key;
                    Object value = t.get(key);
                    if (value == null || CommonUtils.isEmpty(value.toString())) {
                        value = "\u2014";
                    }
                    if ((values = value.toString()).equals("0")) {
                        values = "0.00";
                    }
                    String textValue = null;
                    textValue = values;
                    if (this.isNum(values)) {
                        int hehe = values.indexOf(".");
                        if (hehe > 0) {
                            cell.setCellStyle(style3);
                            cell.setCellValue(this.pasdouble(textValue));
                        } else {
                            HSSFRichTextString richString = new HSSFRichTextString(textValue);
                            cell.setCellValue((RichTextString)richString);
                        }
                    } else {
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        cell.setCellValue((RichTextString)richString);
                    }
                    cell.setCellStyle(styleContent);
                    if (fieldName.equals("payTime")) {
                        cell.setCellStyle(dateStyleContent);
                    }
                    if (fieldName.equals("amountWithoutTax") || fieldName.equals("taxAmount") || fieldName.equals("amountWithTax") || fieldName.equals("totalPayAmount")) {
                        cell.setCellStyle(amountStyleContent);
                    }
                    if (fieldName.equals("taxRate")) {
                        cell.setCellStyle(rateStyleContent);
                    }
                    sheet.setForceFormulaRecalculation(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                ++count;
            }
        }
        logger.info("\u6587\u4ef6\u751f\u6210\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSheetMap(HSSFWorkbook workbook, String title, String[] headers, List<Map> dataset) {
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setColumnWidth(0, 51200);
        sheet.setForceFormulaRecalculation(true);
        HSSFCellStyle styleHeader = workbook.createCellStyle();
        styleHeader.setFillForegroundColor((short)40);
        styleHeader.setFillPattern((short)1);
        styleHeader.setBorderBottom((short)1);
        styleHeader.setBorderLeft((short)1);
        styleHeader.setBorderRight((short)1);
        styleHeader.setBorderTop((short)1);
        styleHeader.setAlignment((short)2);
        HSSFFont fontHeader = workbook.createFont();
        fontHeader.setColor((short)20);
        fontHeader.setFontHeightInPoints((short)12);
        fontHeader.setBoldweight((short)700);
        styleHeader.setFont(fontHeader);
        HSSFCellStyle styleContent = workbook.createCellStyle();
        styleContent.setFillForegroundColor((short)43);
        styleContent.setFillPattern((short)1);
        styleContent.setBorderBottom((short)1);
        styleContent.setBorderLeft((short)1);
        styleContent.setBorderRight((short)1);
        styleContent.setBorderTop((short)1);
        styleContent.setAlignment((short)2);
        styleContent.setVerticalAlignment((short)1);
        HSSFFont fontContent = workbook.createFont();
        fontContent.setBoldweight((short)400);
        styleContent.setFont(fontContent);
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        HSSFCellStyle style3 = workbook.createCellStyle();
        style3.setFillForegroundColor((short)43);
        style3.setFillPattern((short)1);
        style3.setBorderBottom((short)1);
        style3.setBorderLeft((short)1);
        style3.setBorderRight((short)1);
        style3.setBorderTop((short)1);
        style3.setAlignment((short)3);
        style3.setVerticalAlignment((short)1);
        style3.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0.00"));
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        style2.setFont(font2);
        style3.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(styleHeader);
            String header = headers[i];
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            sheet.setColumnWidth((int)i, 30720);
        }
        HSSFFont font3 = workbook.createFont();
        font3.setColor((short)12);
        Iterator<Map> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            logger.info("createSheet row :" + index);
            row = sheet.createRow(++index);
            Map t = it.next();
            int count = 0;
            for (Object key : t.keySet()) {
                HSSFCell cell = row.createCell(count);
                cell.setCellStyle(style2);
                try {
                    String values;
                    Object fieldName = key;
                    Object value = t.get(key);
                    if (value == null || CommonUtils.isEmpty(value.toString())) {
                        value = "\u2014";
                    }
                    if ((values = value.toString()).equals("0")) {
                        values = "0.00";
                    }
                    String textValue = null;
                    textValue = values;
                    if (this.isNum(values)) {
                        int hehe = values.indexOf(".");
                        if (hehe > 0) {
                            cell.setCellStyle(style3);
                            cell.setCellValue(this.pasdouble(textValue));
                        } else {
                            HSSFRichTextString richString = new HSSFRichTextString(textValue);
                            cell.setCellValue((RichTextString)richString);
                        }
                    } else {
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        cell.setCellValue((RichTextString)richString);
                    }
                    cell.setCellStyle(styleContent);
                    sheet.setForceFormulaRecalculation(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                ++count;
            }
        }
        logger.info("\u6587\u4ef6\u751f\u6210\u6210\u529f");
    }
}

