/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class NumberUtils {
    private static final String UNIT = "\u4e07\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u89d2\u5206";
    private static final String DIGIT = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
    private static final double MAX_VALUE = 9.99999999999999E12;

    public static String change(double v) {
        if (v < 0.0) {
            v = -v;
        }
        if (v < 0.0 || v > 9.99999999999999E12) {
            return "\u53c2\u6570\u975e\u6cd5!";
        }
        long l = Math.round(v * 100.0);
        if (l == 0L) {
            return "\u96f6\u5706\u6574";
        }
        String strValue = l + "";
        int i = 0;
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        while (i < strValue.length()) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '\u4ebf' || UNIT.charAt(j) == '\u4e07' || UNIT.charAt(j) == '\u5706') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "\u96f6";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - 48) + UNIT.charAt(j);
            }
            ++i;
            ++j;
        }
        if (!rs.endsWith("\u5206")) {
            rs = rs + "\u6574";
        }
        if (rs.indexOf("\u6574") < 0 && rs.indexOf("\u96f6") < 0) {
            rs = rs.replaceAll("\u62fe\u5706", "\u62fe\u5706\u96f6");
            rs = rs.replaceAll("\u4edf\u5706", "\u4edf\u5706\u96f6");
            rs = rs.replaceAll("\u4e07\u5706", "\u4e07\u5706\u96f6");
        }
        rs = rs.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return rs;
    }

    public static String formatDecimal(BigDecimal number, int n) {
        StringBuilder builder = n > 0 ? new StringBuilder("0.") : new StringBuilder("0");
        for (int i = 0; i < n; ++i) {
            builder.append("0");
        }
        DecimalFormat df2 = new DecimalFormat(builder.toString());
        return df2.format(number);
    }

    public static BigDecimal formatAmount(BigDecimal amount) {
        if (null == amount) {
            return new BigDecimal("0.00");
        }
        return amount.setScale(2, 4);
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return value.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumber(String value) {
        return NumberUtils.isInteger(value) || NumberUtils.isDouble(value);
    }

    public static BigDecimal formatComma2BigDecimal(Object obj) {
        String val = String.valueOf(obj);
        if (val == null) {
            return new BigDecimal("0.00");
        }
        if (!NumberUtils.isNumber(val = val.replaceAll(",", ""))) {
            return new BigDecimal("0.00");
        }
        BigDecimal decimal = new BigDecimal(val);
        decimal = decimal.setScale(2, RoundingMode.HALF_UP);
        return decimal;
    }

    public static String formatCommaAnd2Point(Object obj) {
        String decimalStr;
        DecimalFormat df = new DecimalFormat("#,###.00");
        BigDecimal decimal = NumberUtils.formatComma2BigDecimal(obj);
        String string = decimalStr = df.format(decimal).equals(".00") ? "0.00" : df.format(decimal);
        if (decimalStr.startsWith(".")) {
            decimalStr = "0" + decimalStr;
        }
        return decimalStr;
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal ne = new BigDecimal("1");
        return b.divide(ne, scale, 4).doubleValue();
    }

    public static String subZeroAndDot(Object obj) {
        String str1 = obj + "";
        if (str1.indexOf(".") > 0) {
            str1 = str1.replaceAll("0+?$", "");
            str1 = str1.replaceAll("[.]$", "");
        }
        return str1;
    }

    public static boolean isEdit(Long id) {
        return id != null && id > 0L;
    }
}

