/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ParamValidatorUtil {
    public static String checkParamsStr(Object input) {
        return ParamValidatorUtil.checkParamsStr(input, true);
    }

    public static String checkParamsStr(Object input, boolean failFast) {
        Set<ConstraintViolation<Object>> constraintViolations = ParamValidatorUtil.checkParamsSets(input, failFast);
        if (!constraintViolations.isEmpty()) {
            HashMap regVerify = Maps.newHashMap();
            for (ConstraintViolation<Object> ipiv : constraintViolations) {
                regVerify.put(ipiv.getPropertyPath().toString(), ipiv.getMessage());
            }
            String join = StringUtils.join(regVerify.values(), (String)"\uff1b");
            return join;
        }
        return null;
    }

    public static <T> Set<ConstraintViolation<T>> checkParamsSets(T input, boolean failFast) {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(failFast).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        return validator.validate(input, new Class[0]);
    }
}

