/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import com.xforceplus.purchaser.common.utils.TPCacheUtils;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(TPManagerUtils.class);
    public static final String POOL_IS_BUSY = "busy";
    private static final int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private static final int maximumPoolSize = Runtime.getRuntime().availableProcessors() * 4;
    private static final int slowDealPoolSize = Runtime.getRuntime().availableProcessors() * 3;
    private static final long keepActiveTime = 200L;
    private static final TimeUnit timeUnit = TimeUnit.SECONDS;
    private static final BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(10);
    private static ThreadPoolExecutor customExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, workQueue);
    private static ExecutorService cachedExecutor = Executors.newCachedThreadPool();
    private static ExecutorService fixedExecutor = Executors.newFixedThreadPool(9);
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);

    public static Future<Boolean> submitCustom(Callable<Boolean> callable) {
        if (customExecutor == null) {
            customExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 200L, timeUnit, workQueue);
        }
        Future<Boolean> future = customExecutor.submit(callable);
        if (TPCacheUtils.get(POOL_IS_BUSY) == null && customExecutor.getActiveCount() >= slowDealPoolSize && workQueue.size() > 5) {
            TPCacheUtils.put(POOL_IS_BUSY, (Serializable)((Object)POOL_IS_BUSY));
        }
        if (TPCacheUtils.get(POOL_IS_BUSY) != null) {
            try {
                logger.warn("#################################\u81ea\u5b9a\u4e49\u7ebf\u7a0b\u6c60\u5fd9\u788c\uff01\uff01\uff01#################################");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error("\u7ebf\u7a0b\u6c60\u7761\u7720\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        return future;
    }

    public static Future<Boolean> submitCached(Callable<Boolean> callable) {
        if (cachedExecutor == null) {
            cachedExecutor = Executors.newCachedThreadPool();
        }
        return cachedExecutor.submit(callable);
    }

    public static Future<Boolean> submitFixed(Callable<Boolean> callable) {
        if (fixedExecutor == null) {
            fixedExecutor = Executors.newFixedThreadPool(5);
        }
        return fixedExecutor.submit(callable);
    }

    public static Future<Boolean> submitScheduled(Callable<Boolean> callable, long delay, TimeUnit unit) {
        if (scheduledExecutor == null) {
            scheduledExecutor = Executors.newScheduledThreadPool(2);
        }
        return scheduledExecutor.schedule(callable, delay, unit);
    }

    public static String getCustomExecutorStatus() {
        return customExecutor.toString();
    }

    public static String getFixedExecutorStatus() {
        return fixedExecutor.toString();
    }

    public static String getCachedExecutorStatus() {
        return cachedExecutor.toString();
    }

    public static String getScheduledExecutorStatus() {
        return scheduledExecutor.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(customExecutor.getActiveCount());
    }
}

