/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionTools
extends TransactionSynchronizationAdapter
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionTools.class);
    private static final ThreadLocal<List<Runnable>> RUNNABLES = new ThreadLocal();
    private ExecutorService threadPool = Executors.newFixedThreadPool(5);

    @Override
    public void execute(Runnable runnable) {
        LOGGER.info("Submitting new runnable {} to run after commit", (Object)runnable);
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            LOGGER.info("Transaction synchronization is NOT ACTIVE. Executing right now runnable {}", (Object)runnable);
            runnable.run();
            return;
        }
        List<Runnable> threadRunnables = RUNNABLES.get();
        if (threadRunnables == null) {
            threadRunnables = new ArrayList<Runnable>();
            RUNNABLES.set(threadRunnables);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
        }
        threadRunnables.add(runnable);
    }

    public void afterCommit() {
        List<Runnable> threadRunnables = RUNNABLES.get();
        LOGGER.info("Transaction successfully committed, executing {} runnables", (Object)threadRunnables.size());
        for (int i = 0; i < threadRunnables.size(); ++i) {
            Runnable runnable = threadRunnables.get(i);
            LOGGER.info("Executing runnable {}", (Object)runnable);
            try {
                this.threadPool.execute(runnable);
                continue;
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to execute runnable " + runnable, (Throwable)e);
            }
        }
    }

    public void afterCompletion(int status) {
        LOGGER.info("Transaction completed with status {}", (Object)(status == 0 ? "COMMITTED" : "ROLLED_BACK"));
        RUNNABLES.remove();
    }
}

