/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import org.apache.commons.lang3.StringUtils;

public class ValidField {
    public static final int NOT_NULL = 1;
    public static final int INCLUDE = 2;
    public static final int MAX_LEN = 3;
    public static final int MATCH_REGEX = 4;
    private String fieldName;
    private Object fieldValue;
    private int validType;
    private int maxLen;
    private String regex;
    private Object[] validValues;

    public ValidField() {
    }

    public ValidField(String fieldName, Object fieldValue, int validType) {
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.validType = validType;
    }

    public ValidField(String fieldName, String fieldValue, int validType, int maxLen) {
        this(fieldName, fieldValue, validType);
        this.maxLen = maxLen;
    }

    public ValidField(String fieldName, String fieldValue, int validType, String regex) {
        this(fieldName, fieldValue, validType);
        this.regex = regex;
    }

    public ValidField(String fieldName, Object fieldValue, int validType, Object[] validValues) {
        this(fieldName, fieldValue, validType);
        this.validValues = validValues;
    }

    public String isValidOK() {
        switch (this.validType) {
            case 1: {
                return this.fieldValue == null ? "\u5b57\u6bb5[" + this.fieldName + "]\u4e0d\u80fd\u4e3a\u7a7a" : "OK";
            }
            case 2: {
                if (this.fieldValue == null) {
                    return "\u5b57\u6bb5[" + this.fieldName + "]\u4e0d\u80fd\u4e3a\u7a7a";
                }
                for (Object validValue : this.validValues) {
                    if (!this.fieldValue.equals(validValue)) continue;
                    return "OK";
                }
                return "\u5b57\u6bb5[" + this.fieldName + "]\u4f20\u5165\u503c\u975e\u6cd5";
            }
            case 3: {
                if (this.fieldValue == null) {
                    return "OK";
                }
                if (this.fieldValue instanceof String) {
                    int fieldLen = ((String)this.fieldValue).length();
                    return this.maxLen >= fieldLen ? "OK" : "\u5b57\u6bb5[" + this.fieldName + "]\u8d85\u8fc7\u6700\u5927\u957f\u5ea6[" + this.maxLen + "]";
                }
                return "OK";
            }
            case 4: {
                if (this.fieldValue == null) {
                    return "OK";
                }
                if (this.fieldValue instanceof String) {
                    String fieldStr = (String)this.fieldValue;
                    if (StringUtils.isEmpty((CharSequence)fieldStr)) {
                        return "OK";
                    }
                    return fieldStr.matches(this.regex) ? "OK" : "\u5b57\u6bb5[" + this.fieldName + "]\u4e0d\u5408\u6cd5";
                }
                return "OK";
            }
        }
        return "OK";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(Object fieldValue) {
        this.fieldValue = fieldValue;
    }

    public int getValidType() {
        return this.validType;
    }

    public void setValidType(int validType) {
        this.validType = validType;
    }

    public Object[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(Object[] validValues) {
        this.validValues = validValues;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }
}

