/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public final class ZipUtils {
    private int bufferLen = 0x100000;

    private ZipUtils() {
        throw new UnsupportedOperationException();
    }

    private ZipUtils(int bufferLen) {
        this.bufferLen = bufferLen;
    }

    public static ZipUtils getInstance() {
        return new ZipUtils(0x100000);
    }

    public static ZipUtils getInstance(int bufferLen) {
        return new ZipUtils(bufferLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCompress(File srcFile, File destFile) throws IOException {
        ZipArchiveOutputStream out = null;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(srcFile), this.bufferLen);
            out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destFile), this.bufferLen));
            ZipArchiveEntry entry = new ZipArchiveEntry(srcFile.getName());
            entry.setSize(srcFile.length());
            out.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)is, (OutputStream)out);
            out.closeArchiveEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        IOUtils.closeQuietly((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDecompress(String zipFilePath, String outDirStr) throws IOException {
        File zipFile = new File(zipFilePath);
        File outDir = new File(outDirStr);
        ZipArchiveInputStream is = null;
        try {
            is = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(zipFile), this.bufferLen));
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                if (entry.isDirectory()) {
                    File directory = new File(outDir, entry.getName());
                    directory.mkdirs();
                    continue;
                }
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(new File(outDir, entry.getName())), this.bufferLen);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)os);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unZip(String outDirPath, String unZipfilePath) throws IOException {
        FileOutputStream fileOutStream = null;
        InputStream inputStream = null;
        ZipFile zipFile = null;
        File outDir = new File(outDirPath);
        File unZipfile = new File(unZipfilePath);
        if (!unZipfile.exists()) {
            throw new FileNotFoundException("File to upzip:" + unZipfilePath + " not found!");
        }
        try {
            zipFile = new ZipFile(unZipfile);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                File file = new File(outDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    inputStream = zipFile.getInputStream(entry);
                    fileOutStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable)inputStream);
                    IOUtils.closeQuietly(fileOutStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
                IOUtils.closeQuietly((Closeable)fileOutStream);
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zipFile);
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
        IOUtils.closeQuietly(inputStream);
    }

    public InputStream readFileFromSingleFile(ZipFile zipFile, ZipArchiveEntry entry) throws IOException {
        InputStream inputStream = zipFile.getInputStream(entry);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFiles(ZipArchiveOutputStream out, File dir, String pathName) throws IOException {
        InputStream is = null;
        File[] files = dir.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File zFile = files[i];
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(zFile, pathName + zFile.getName()));
            if (zFile.isDirectory()) {
                this.packFiles(out, zFile, pathName + zFile.getName() + "/");
                continue;
            }
            try {
                is = new BufferedInputStream(new FileInputStream(zFile), this.bufferLen);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                continue;
            }
            finally {
                is.close();
            }
        }
    }

    public void zip(String srcFileStr, String destFileStr) throws IOException {
        File destFile = new File(destFileStr);
        File srcFile = new File(srcFileStr);
        this.zip(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File srcFile, File destFile) throws IOException {
        ZipArchiveOutputStream out = null;
        File pfile = destFile.getParentFile();
        if (!pfile.exists()) {
            pfile.mkdirs();
        }
        if (srcFile.isFile()) {
            this.doCompress(srcFile, destFile);
            return;
        }
        try {
            out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destFile), this.bufferLen));
            this.packFiles(out, srcFile, "");
            out.closeArchiveEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEntryToAnother(ZipFile srcFile, File destFile, ArrayList<ZipArchiveEntry> entryList) throws IOException {
        Closeable out = null;
        FileOutputStream fileOutStream = null;
        InputStream inputStream = null;
        String tempDirStr = System.getProperty("java.io.tmpdir") + "temp" + File.separatorChar;
        File tempDir = new File(tempDirStr, String.valueOf(System.currentTimeMillis()));
        tempDir.mkdirs();
        try {
            for (ZipArchiveEntry entry : entryList) {
                File file = new File(tempDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    inputStream = srcFile.getInputStream(entry);
                    fileOutStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable)inputStream);
                    IOUtils.closeQuietly(fileOutStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
                IOUtils.closeQuietly((Closeable)fileOutStream);
            }
            this.zip(tempDir, destFile);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
        IOUtils.closeQuietly(out);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ZipUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

