/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purchaser.common.utils.excel.read;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purchaser.common.utils.excel.read.ExcelException;
import com.xforceplus.purchaser.common.utils.excel.read.ExcelExceptionEnum;
import com.xforceplus.purchaser.common.utils.excel.read.ExcelHeader;
import com.xforceplus.purchaser.common.utils.excel.read.ExcelRowModel;
import com.xforceplus.purchaser.common.utils.excel.read.ImportModifyPaymentStatusBean;
import com.xforceplus.purchaser.common.utils.excel.read.RepeatSetFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExcelReadTools<T extends ExcelRowModel> {
    private static final Logger log = LoggerFactory.getLogger(ExcelReadTools.class);
    private Map<Integer, String> indexRefFieldMaps = Maps.newHashMap();
    private Map<String, String> headerRefFieldMaps = Maps.newHashMap();
    private RepeatSetFunction<T> repeatSetFunction;
    private Map<String, List<Integer>> repeatRowNumMap = new HashMap<String, List<Integer>>();

    public static <T> ExcelReadTools newInstance() {
        return new ExcelReadTools<T>();
    }

    private ExcelReadTools() {
    }

    public List<T> importExcel(File file, String sheetName, Class<T> clazz, Long maxNum) {
        return this.importExcel(file, sheetName, clazz, maxNum, null);
    }

    public List<T> importExcel(File file, String sheetName, Class<T> clazz, Long maxNum, RepeatSetFunction function) {
        this.repeatSetFunction = function;
        Sheet sheet = this.getSheet(file, sheetName);
        this.handleHeader(sheet, clazz);
        return this.readExcelData(sheet, clazz, maxNum);
    }

    private Sheet getSheet(File file, String sheetName) {
        Workbook wb = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            throw new ExcelException(ExcelExceptionEnum.EXCEL_NOT_FOUND_ERROR);
        }
        catch (InvalidFormatException e) {
            throw new ExcelException(ExcelExceptionEnum.FILE_TYPE_ERROR);
        }
        catch (Exception e) {
            throw new ExcelException(ExcelExceptionEnum.UNKNOWN_ERROR);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                log.error("##### File closing exception\uff1a{}", (Throwable)e);
            }
        }
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new ExcelException(ExcelExceptionEnum.SHEET_NOT_FOUND_ERROR);
        }
        return sheet;
    }

    private void handleHeader(Sheet sheet, Class clazz) {
        HashMap readHeaderMaps = Maps.newHashMap();
        Row firstRow = sheet.getRow(0);
        for (Cell cell : firstRow) {
            String cellValue = this.getCellValue(cell);
            if (StringUtils.isEmpty((Object)cellValue)) continue;
            readHeaderMaps.put(cellValue, cell.getColumnIndex());
        }
        log.info("##### \u8bfb\u53d6Excel \u8868\u5934\u5217\u8868\uff1a{}", (Object)readHeaderMaps);
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            ExcelHeader annotation = field.getAnnotation(ExcelHeader.class);
            if (null == annotation) continue;
            this.headerRefFieldMaps.put(annotation.value(), field.getName());
        }
        log.info("##### \u8bfb\u53d6{} \u914d\u7f6e\u5217\u5934\u4fe1\u606f\u5217\u8868\uff1a{}", (Object)clazz, this.headerRefFieldMaps);
        for (String key : this.headerRefFieldMaps.keySet()) {
            Integer columnIndex = (Integer)readHeaderMaps.get(key);
            if (null == columnIndex) {
                throw new ExcelException(ExcelExceptionEnum.COLUMN_HEADER_ERROR);
            }
            this.indexRefFieldMaps.put(columnIndex, this.headerRefFieldMaps.get(key));
        }
        log.info("##### \u8868\u5934\u68c0\u67e5 & \u8d4b\u503c\u5173\u7cfb\u914d\u7f6e\u5217\u8868\uff1a{}", this.headerRefFieldMaps);
    }

    private List<T> readExcelData(Sheet sheet, Class<T> clazz, Long maxNum) {
        ArrayList result = Lists.newArrayList();
        int rowNum = 1;
        for (Row row : sheet) {
            if (row.getLastCellNum() <= 0) continue;
            if (rowNum == 1) {
                ++rowNum;
                continue;
            }
            if ((long)rowNum > maxNum + 1L) {
                log.debug("##### excel \u6587\u4ef6\u884c\u6570\u8d85\u8fc7\u6700\u5927\u6570\u91cf,\u5f53\u524d\u52a0\u8868\u5934\u884c\u6570:{}", (Object)rowNum);
                throw new ExcelException(ExcelExceptionEnum.LINE_NUM_ERROR);
            }
            try {
                ExcelRowModel obj = (ExcelRowModel)clazz.newInstance();
                for (Integer key : this.indexRefFieldMaps.keySet()) {
                    Cell cell = row.getCell(key.intValue());
                    if (null == cell) {
                        log.debug("#### \u8868\u5934\u6709\u6570\u636e\uff0c\u6570\u636e\u5217\u8868\u672a\u627e\u5230cell\uff1a{}\uff1a{}", (Object)key, (Object)this.indexRefFieldMaps.get(key));
                        continue;
                    }
                    Field field = clazz.getDeclaredField(this.indexRefFieldMaps.get(key));
                    field.setAccessible(true);
                    field.set(obj, this.getFieldValue(field, cell));
                }
                if (this.isNotEmpty(obj)) {
                    this.setRepeatKey(obj, rowNum);
                    obj.setRowNum(rowNum);
                    result.add(obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++rowNum;
        }
        this.statisRepeats(result);
        return result;
    }

    private void statisRepeats(List<T> datas) {
        if (null != this.repeatSetFunction) {
            for (ExcelRowModel data : datas) {
                List<Integer> rowNums = this.repeatRowNumMap.get(data.getRepeatKey());
                if (null == rowNums || rowNums.size() <= 1) continue;
                data.setRepeatRowNums(rowNums);
            }
        }
    }

    private void setRepeatKey(T obj, int rowNum) {
        if (null != this.repeatSetFunction) {
            this.repeatSetFunction.repeat(obj);
            List<Integer> rows = this.repeatRowNumMap.get(((ExcelRowModel)obj).getRepeatKey());
            if (null == rows) {
                rows = new ArrayList<Integer>();
                this.repeatRowNumMap.put(((ExcelRowModel)obj).getRepeatKey(), rows);
            }
            rows.add(rowNum);
        }
    }

    private String getCellValue(Cell cell) {
        String ret = null;
        try {
            if (cell != null) {
                switch (cell.getCellType()) {
                    case 4: {
                        ret = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            double d = cell.getNumericCellValue();
                            Date date = DateUtil.getJavaDate((double)d);
                            ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                            break;
                        }
                        Long temp = Math.round(cell.getNumericCellValue());
                        if (Double.parseDouble(temp + ".0") == cell.getNumericCellValue()) {
                            ret = temp + "";
                            break;
                        }
                        ret = CommonUtils.getPlainString(String.valueOf(cell.getNumericCellValue()));
                        break;
                    }
                    case 1: {
                        ret = cell.getStringCellValue().trim();
                        if (!StringUtils.isEmpty((Object)ret)) break;
                        ret = null;
                        break;
                    }
                    case 2: {
                        try {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                ret = new SimpleDateFormat("yyyy-MM-dd").format(cell.getDateCellValue());
                                break;
                            }
                            ret = this.parseFormula(cell);
                        }
                        catch (Exception e) {
                            ret = String.valueOf(cell.getRichStringCellValue());
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExcelException(ExcelExceptionEnum.CELL_FORMAT_ERROR);
        }
        return ret;
    }

    private String parseFormula(Cell cell) {
        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        String ret = "";
        switch (cellValue.getCellType()) {
            case 4: {
                ret = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    double d = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)d);
                    ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                Long temp = Math.round(cell.getNumericCellValue());
                if (Double.parseDouble(temp + ".0") == cell.getNumericCellValue()) {
                    ret = temp + "";
                    break;
                }
                ret = CommonUtils.getPlainString(String.valueOf(cell.getNumericCellValue()));
                break;
            }
            case 1: {
                ret = cell.getStringCellValue().trim();
            }
        }
        return ret;
    }

    private Object getFieldValue(Field field, Cell cell) {
        if (BigDecimal.class.isAssignableFrom(field.getType())) {
            if (cell.getCellType() == 1) {
                return BigDecimal.valueOf(Double.parseDouble(cell.getStringCellValue()));
            }
            return BigDecimal.valueOf(cell.getNumericCellValue());
        }
        if (Boolean.class.isAssignableFrom(field.getType())) {
            return cell.getBooleanCellValue();
        }
        if (Integer.class.isAssignableFrom(field.getType())) {
            Long temp = Math.round(cell.getNumericCellValue());
            return temp.intValue();
        }
        if (Double.class.isAssignableFrom(field.getType())) {
            return cell.getNumericCellValue();
        }
        return this.getCellValue(cell);
    }

    private boolean isNotEmpty(Object obj) {
        boolean result = false;
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (StringUtils.isEmpty((Object)value)) continue;
                result = true;
            }
        }
        catch (Exception e) {
            log.error("#### \u5224\u65ad\u5bf9\u8c61\u5c5e\u6027\u503c\u662f\u5426null\u6216\u8005\u662f\u7a7a \u53d1\u9001\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        ExcelReadTools tools = ExcelReadTools.newInstance();
        long l = System.currentTimeMillis();
        List<ImportModifyPaymentStatusBean> importList = tools.importExcel(new File("d:/abc.xlsx"), "\u4ed8\u6b3e\u72b6\u6001\u4fee\u6539\u5217\u8868", ImportModifyPaymentStatusBean.class, 50000L, new RepeatSetFunction<ImportModifyPaymentStatusBean>(){

            @Override
            public void repeat(ImportModifyPaymentStatusBean info) {
                info.setRepeatKey(info.getInvoiceNo() + info.getInvoiceCode());
            }
        });
        System.out.println("\u6d88\u8017\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - l));
        for (ImportModifyPaymentStatusBean bean : importList) {
            System.out.println(JsonUtils.writeObjectToJson(bean));
        }
    }
}

