/*
 * Decompiled with CFR 0.152.
 */
import enums.InvoiceType;

public class InvoiceTools {
    public static String getInvoceType(String invoiceCode) {
        String invoiceType = "";
        if (StringTools.isNotEmpty(invoiceCode)) {
            if (invoiceCode.length() == 10) {
                if (invoiceCode.matches("^\\d{7}(1|5)\\d{2}")) {
                    invoiceType = InvoiceType.SPECIAL.value();
                } else if (invoiceCode.matches("^\\d{7}(3|6)\\d{2}")) {
                    invoiceType = InvoiceType.NORMAL.value();
                }
            } else if (invoiceCode.length() == 12) {
                if (invoiceCode.matches("^0\\d{9}11")) {
                    invoiceType = InvoiceType.ELECTRONIC.value();
                } else if (invoiceCode.matches("^0\\d{9}(06|07)")) {
                    invoiceType = InvoiceType.NORMALROLL.value();
                } else if (invoiceCode.matches("^1\\d{6}2\\d{4}")) {
                    invoiceType = InvoiceType.VEHICLE.value();
                } else if (invoiceCode.matches("^0\\d{9}12")) {
                    invoiceType = InvoiceType.TRAFFIC.value();
                } else if (invoiceCode.matches("^0\\d{9}(04|05)")) {
                    invoiceType = InvoiceType.NORMAL.value();
                } else if (invoiceCode.matches("^1\\d{9}10")) {
                    invoiceType = InvoiceType.BLOCKCHAIN_INVOICE.value();
                }
            }
        }
        return invoiceType;
    }
}

