/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.redisson;

import com.xforceplus.phoenix.tools.enable.AutoConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class RedissonConfiguration
implements AutoConfiguration {
    @Value(value="${redis.type:standalone}")
    private String type;
    @Value(value="${redis.standaloneHost}")
    private String standaloneHost;
    @Value(value="${redis.standalonePort}")
    private Integer standalonePort;
    @Value(value="${redis.maxActive:20}")
    private int maxActive;
    @Value(value="${redis.maxIdle}")
    private Integer maxIdle;
    @Value(value="${redis.minIdle:5}")
    private Integer minIdle;
    @Value(value="${redis.maxTotal}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis}")
    private Integer maxWaitMillis;
    @Value(value="${redis.minEvictableIdleTimeMillis}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${redis.numTestsPerEvictionRun}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${redis.timeBetweenEvictionRunsMillis}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${redis.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${redis.testWhileIdle:false}")
    private boolean testWhileIdle;
    @Value(value="${redis.sentinelNodes}")
    private String sentinelNodes;
    @Value(value="${redis.sentinelMaster}")
    private String sentinelMaster;
    @Value(value="${redis.password}")
    private String password;
    @Value(value="${redis.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${redis.timeout:3000}")
    private Integer timeout;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        String prefix = "redis://";
        String standaloneType = "standalone";
        if (Objects.equals(this.type, "standalone")) {
            String address = "redis://" + this.standaloneHost + ":" + this.standalonePort;
            ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(address).setPassword(this.password)).setConnectionPoolSize(this.maxActive).setConnectionMinimumIdleSize(this.minIdle.intValue()).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
        } else {
            String[] sentinelNodeArray;
            StringBuilder sentinelAddressBuilder = new StringBuilder();
            for (String node : sentinelNodeArray = StringUtils.split((String)this.sentinelNodes, (String)",")) {
                sentinelAddressBuilder.append("redis://").append(node).append(",");
            }
            String sentinelAddress = sentinelAddressBuilder.toString();
            ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.sentinelMaster).addSentinelAddress(new String[]{sentinelAddress.substring(0, sentinelAddress.length() - 1)}).setPassword(this.password)).setMasterConnectionPoolSize(this.maxActive)).setMasterConnectionMinimumIdleSize(this.minIdle.intValue())).setSlaveConnectionPoolSize(this.maxActive)).setSlaveConnectionMinimumIdleSize(this.minIdle.intValue())).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
        }
        return Redisson.create((Config)config);
    }
}

