/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.transaction.impl;

import com.xforceplus.phoenix.tools.constant.RedissonConstants;
import com.xforceplus.phoenix.tools.exception.LockException;
import com.xforceplus.phoenix.tools.transaction.TransactionLockServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.TransactionServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTransactionLockServiceInvokerImpl
implements TransactionLockServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionLockServiceInvokerImpl.class);
    @Autowired
    private TransactionServiceInvoker transactionServiceInvoker;

    @Override
    public void callNewTxWithLock(RLock lock, Runnable runnable) {
        this.callNewTxWithLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND, runnable);
    }

    @Override
    public void callNewTxWithLock(RLock lock, long lockLeaseTimeMillISecond, Runnable runnable) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, lockLeaseTimeMillISecond);
            this.transactionServiceInvoker.callNewTx(runnable, (Long)lockLeaseTimeMillISecond);
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1> void callNewTxWithLock(RLock lock, Consumer<A1> consumer, A1 arg1) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            this.transactionServiceInvoker.callNewTx(consumer, arg1, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <R> R callNewTxWithLock(RLock lock, Supplier<R> supplier) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(supplier, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, R> R callNewTxWithLock(RLock lock, Function<A1, R> function, A1 arg1) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(function, arg1, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, A2, R> R callNewTxWithLock(RLock lock, BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(biFunction, arg1, arg2, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, A2, A3, R> R callNewTxWithLock(RLock lock, long lockLeaseTimeMillISecond, Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, lockLeaseTimeMillISecond);
            R r = this.transactionServiceInvoker.callNewTx(function3, arg1, arg2, arg3, lockLeaseTimeMillISecond);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    private void tryLock(RLock lock, long lockLeaseTimeMillISecond) {
        try {
            boolean lockFlag = lock.tryLock(RedissonConstants.LOCK_NORMAL_WAIT_TIME_SECOND.longValue(), lockLeaseTimeMillISecond, TimeUnit.MILLISECONDS);
            if (!lockFlag) {
                throw new LockException(String.format("\u9501: %s \u5c1d\u8bd5\u83b7\u53d6\u5931\u8d25", lock.toString()));
            }
        }
        catch (InterruptedException e) {
            throw new LockException(e.getMessage());
        }
    }

    private void unLock(boolean releaseLock, RLock lock) {
        if (releaseLock) {
            lock.unlock();
        }
    }
}

