/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import com.xforceplus.phoenix.tools.exception.UtilException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e.getMessage());
        }
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtil.getSecureRandom() : RandomUtil.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtil.randomInt(2);
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtil.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomUtil.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return RandomUtil.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return RandomUtil.getRandom().nextDouble(min, max);
    }
}

