/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.util.regex.Pattern;

public class RegexUtil {
    private static final String NUMBER_REGEX = "^-?\\d+(\\.\\d+)?$";
    private static final String ENGLISH_NUMBER_REGEX = "^[\\d\\/\\\\a-zA-Z_-]+$";
    private static final String MOBILE_REGEX = "^[1][0-9][0-9]{9}$";
    private static final String PHONE_REGEX = "^[1-9]{1}[0-9]{5,8}$";
    private static final String PHONE_WITH_ZONE_REGEX = "^[0][1-9]{2,3}-[0-9]{5,10}$";
    private static final String AMOUNT_REGEX = "(^[0-9]{1,12}$)|(^[0-9]{1,12}[\\.]{1}[0-9]{1,6}$)";
    private static final String EMAIL_REGEX = "[A-z]+[A-z0-9_-]*\\@[A-z0-9]+\\.[A-z]+";

    private RegexUtil() {
    }

    public static boolean isEmail(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(EMAIL_REGEX);
        return pattern.matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUMBER_REGEX);
        return pattern.matcher(str).matches();
    }

    public static boolean isContractNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(ENGLISH_NUMBER_REGEX);
        return pattern.matcher(str).matches();
    }

    public static boolean isMobile(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(MOBILE_REGEX);
        return pattern.matcher(str).matches();
    }

    public static boolean isPhone(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = str.length() > 9 ? Pattern.compile(PHONE_WITH_ZONE_REGEX) : Pattern.compile(PHONE_REGEX);
        return pattern.matcher(str).matches();
    }

    public static boolean isAmount(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(AMOUNT_REGEX);
        return pattern.matcher(str).matches();
    }
}

