package com.xforceplus.phoenix.tools.enable;

import com.xforceplus.phoenix.tools.event.EventAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @program: phoenix-purchaser-tools
 * @description 启用进项自定义配置
 * Guava Event Module
 * Redisson Module
 * @author: wdye
 * @created: 2020-03-27 11:31
 */
@Configuration
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(EnablePurConfigurationImport.class)
@Documented
public @interface EnablePurConfiguration {
    Class<? extends AutoConfiguration>[] value() default {EventAutoConfiguration.class};
}
