package com.xforceplus.phoenix.tools.enable;

import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

import java.util.Collections;
import java.util.List;

/**
 * @program: phoenix-purchaser-tools
 * @description 导入工具包服务
 * @author: wdye
 * @created: 2020-03-27 14:51
 */
public class EnablePurConfigurationImport implements ImportSelector {
    public EnablePurConfigurationImport() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata metadata) {
        MultiValueMap<String, Object> attributes = metadata.getAllAnnotationAttributes(EnablePurConfiguration.class.getName());
        return this.collectClassNames(attributes != null ? (List) attributes.get("value") : Collections.emptyList());
    }

    private String[] collectClassNames(List<Object> values) {
        String[] valueArray = new String[values.size()];
        int i = 0;
        for (Object value : values) {
            valueArray[i] = ((Class[]) value)[0].getName();
            i++;
        }
        return valueArray;
    }
}
