package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 发票勾选状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-06 16:04
 */
public enum AuthStatusEnum implements IEnumIntValue {

    /**
     * 默认
     */
    DEFAULT(0,  "默认"),
    /**
     * 不可勾选
     */
    NOT_AUTH(1,  "不可勾选"),
    /**
     * 未勾选
     */
    NO_AUTH(2,  "未勾选"),
    /**
     * 勾选中
     */
    AUTHING(3,  "勾选中"),
    /**
     * 已勾选
     */
    SUCCCESS_AUTH(4,  "已勾选"),
    /**
     * 勾选失败
     */
    FAIL_AUTH(5,  "勾选失败"),
    /**
     * 抵扣异常
     */
    EXCE_AUTH(6, "抵扣异常"),
    /**
     * 已确认抵扣
     */
    DEDUCTION_SUCCESS(8,  "已确认抵扣"),
    ;

    private final Integer value;
    private final String description;

    AuthStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
