package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 记账状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 10:00
 */
public enum ChargeUpStatusEnum implements IEnumIntValue {
    /**
     * 未记账
     */
    NOT_CHARGE(0,"未记账"),
    /**
     * 已记账
     */
    CHARGE(1,"已记账"),
    /**
     * 记账失败
     */
    FAIL_CHARGE(2,"记账失败"),
    ;

    private final Integer value;
    private final String description;

    ChargeUpStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
