package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;
import org.apache.commons.lang3.StringUtils;

import java.util.stream.Stream;

/**
 * @author liuda
 * @version 1.0
 * @date 2020/8/21 15:54
 */
public enum ElRecogBillTypeEnum implements IEnumStringValue {
    PURCHASER_BILL("purchaseBill","采购类单据"),
    EXPENSES_BILL("expensesBill","费用类单据"),
    ACCOUNT_BILL("accountBill","记账工单"),
    STATEMENT_BILL("statementBill","对账单");
    private final String code;
    private final String description;
    ElRecogBillTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String value() {
        return this.code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 获取中文描述
     * @param code
     * @return
     */
    public static String converElRecogBillType(String code) {
        return Stream.of(ElRecogBillTypeEnum.values())
                .filter(t -> t.code.equals(code))
                .findFirst().map(ElRecogBillTypeEnum::getDescription).orElse(StringUtils.EMPTY);
    }
}
