package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 发票暂存状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-06 16:00
 */
public enum HangStatusEnum implements IEnumIntValue {

    /**
     * 默认
     */
    DEFAULT(0,"默认"),
    /**
     * 挂起
     */
    HANG(1,"挂起"),
    ;

    private final Integer value;
    private final String description;

    HangStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
