package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;
/**
 * @program: phoenix-purchaser-tools
 * @description 发票状态枚举
 * @author: 刘达
 * @created: 2020-04-27 14:11
 */
public enum InvoiceStatusEnum implements IEnumIntValue {

    /**
     * 默认
     */
    DEFAULT(0, "默认"),
    /**
     * 正常
     */
    NORMAL(1, "正常"),
    /**
     * 作废
     */
    CANCELED(2, "作废"),
    /**
     * 红冲
     */
    BE_RED(3, "红冲"),
    /**
     * 部分红冲
     */
    BE_PART_RED(4, "部分红冲"),
    /**
     * 异常
     */
    ABNORMAL(7, "异常"),
    /**
     * 失控
     */
    LOSE_CONTROL(8, "失控"),
    /**
     * 删除
     */
    DELETED(9, "删除");

    private final Integer code;
    private final String msg;

    InvoiceStatusEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer code(){
        return code;
    }

    public String msg(){
        return msg;
    }

    @Override
    public Integer value() {
        return code;
    }
}
