package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;

import java.util.stream.Stream;

/**
 * @program: phoenix-purchaser-tools
 * @description 发票类型枚举
 * @author: wdye
 * @created: 2020-01-14 14:11
 */
public enum InvoiceTypeEnum implements IEnumStringValue {

    SPECIAL_ELECTRONIC("se", "^0\\d{9}13", "增值税电子专用发票"),
    SPECIAL("s", "^\\d{7}(1|5)\\d{2}", "增值税专用发票"),
    NORMAL("c", "(^\\d{7}(3|6)\\d{2})|(^0\\d{9}(04|05))", "增值税普通发票"),
    ELECTRONIC("ce", "^0\\d{9}11", "增值税电子普通发票"),
    NORMAL_ROLL("ju", "^0\\d{9}(06|07)", "增值税普通发票(卷票)"),
    TRAFFIC("ct", "^0\\d{9}12", "增值税电子普通发票(通行费)"),
    VEHICLE("v", "^1\\d{6}2\\d{4}", "机动车统一销售发票"),
    // 由于区块链发票也归属于电票，所以类型也为ce
    BLOCK_CHAIN_INVOICE("ce", "^1\\d{9}10", "区块链发票"),
    TRANSPORT("y", "", "运输业增值税专用发票"),
    COMMON_ELECTRONIC("cd","^2\\d{9}11","通用(电子)发票");

    private final String value;
    private final String regex;
    private final String description;

    InvoiceTypeEnum(String value, String regex, String description) {
        this.value = value;
        this.regex = regex;
        this.description = description;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }

    public String getRegex() {
        return regex;
    }

    public static InvoiceTypeEnum fromValue(String value) {
        return Stream.of(InvoiceTypeEnum.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElse(null);
    }

    public static InvoiceTypeEnum fromMatchesInvoiceCode(String invoiceCode) {
        return Stream.of(InvoiceTypeEnum.values())
                .filter(p -> invoiceCode.matches(p.getRegex()))
                .findFirst().orElse(null);
    }
}

