package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 核销状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 10:13
 */
public enum SaleConfirmStatusEnum implements IEnumIntValue {
    /**
     * 未核销
     */
    NOT_SALE_CONFIRM(0,"未核销"),
    /**
     * 部分核销
     */
    PART_SALE_CONFIRM(1,"部分核销"),
    /**
     * 已核销
     */
    COMPLETE_SALE_CONFIRM(2,"已核销"),
    ;

    private final Integer value;
    private final String description;

    SaleConfirmStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
